/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.worklink.WorkLinkAsyncClient;
import software.amazon.awssdk.services.worklink.model.ListDomainsRequest;
import software.amazon.awssdk.services.worklink.model.ListDomainsResponse;

public class ListDomainsPublisher
implements SdkPublisher<ListDomainsResponse> {
    private final WorkLinkAsyncClient client;
    private final ListDomainsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainsPublisher(WorkLinkAsyncClient client, ListDomainsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainsPublisher(WorkLinkAsyncClient client, ListDomainsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDomainsResponseFetcher
    implements AsyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainsResponse> nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsPublisher.this.client.listDomains(ListDomainsPublisher.this.firstRequest);
            }
            return ListDomainsPublisher.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

