/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse;

public class ListLanguageModelsPublisher
implements SdkPublisher<ListLanguageModelsResponse> {
    private final TranscribeAsyncClient client;
    private final ListLanguageModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLanguageModelsPublisher(TranscribeAsyncClient client, ListLanguageModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLanguageModelsPublisher(TranscribeAsyncClient client, ListLanguageModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLanguageModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLanguageModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLanguageModelsResponseFetcher
    implements AsyncPageFetcher<ListLanguageModelsResponse> {
        private ListLanguageModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListLanguageModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLanguageModelsResponse> nextPage(ListLanguageModelsResponse previousPage) {
            if (previousPage == null) {
                return ListLanguageModelsPublisher.this.client.listLanguageModels(ListLanguageModelsPublisher.this.firstRequest);
            }
            return ListLanguageModelsPublisher.this.client.listLanguageModels((ListLanguageModelsRequest)((Object)ListLanguageModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

