/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.internal.UserAgentUtils;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfo;

public class ListWorkflowTypesPublisher
implements SdkPublisher<ListWorkflowTypesResponse> {
    private final SwfAsyncClient client;
    private final ListWorkflowTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowTypesPublisher(SwfAsyncClient client, ListWorkflowTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowTypesPublisher(SwfAsyncClient client, ListWorkflowTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowTypeInfo> typeInfos() {
        Function<ListWorkflowTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeInfos() != null) {
                return response.typeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowTypesResponseFetcher
    implements AsyncPageFetcher<ListWorkflowTypesResponse> {
        private ListWorkflowTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListWorkflowTypesResponse> nextPage(ListWorkflowTypesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowTypesPublisher.this.client.listWorkflowTypes(ListWorkflowTypesPublisher.this.firstRequest);
            }
            return ListWorkflowTypesPublisher.this.client.listWorkflowTypes((ListWorkflowTypesRequest)((Object)ListWorkflowTypesPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

