/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.HistoryEvent;

public class GetWorkflowExecutionHistoryPublisher
implements SdkPublisher<GetWorkflowExecutionHistoryResponse> {
    private final SwfAsyncClient client;
    private final GetWorkflowExecutionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetWorkflowExecutionHistoryPublisher(SwfAsyncClient client, GetWorkflowExecutionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetWorkflowExecutionHistoryPublisher(SwfAsyncClient client, GetWorkflowExecutionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetWorkflowExecutionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetWorkflowExecutionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HistoryEvent> events() {
        Function<GetWorkflowExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetWorkflowExecutionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetWorkflowExecutionHistoryResponseFetcher
    implements AsyncPageFetcher<GetWorkflowExecutionHistoryResponse> {
        private GetWorkflowExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkflowExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetWorkflowExecutionHistoryResponse> nextPage(GetWorkflowExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetWorkflowExecutionHistoryPublisher.this.client.getWorkflowExecutionHistory(GetWorkflowExecutionHistoryPublisher.this.firstRequest);
            }
            return GetWorkflowExecutionHistoryPublisher.this.client.getWorkflowExecutionHistory((GetWorkflowExecutionHistoryRequest)((Object)GetWorkflowExecutionHistoryPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

