/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse;
import software.amazon.awssdk.services.ssmsap.model.Operation;

public class ListOperationsPublisher
implements SdkPublisher<ListOperationsResponse> {
    private final SsmSapAsyncClient client;
    private final ListOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOperationsPublisher(SsmSapAsyncClient client, ListOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOperationsPublisher(SsmSapAsyncClient client, ListOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Operation> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOperationsResponseFetcher
    implements AsyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOperationsResponse> nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsPublisher.this.client.listOperations(ListOperationsPublisher.this.firstRequest);
            }
            return ListOperationsPublisher.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

