/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse;
import software.amazon.awssdk.services.ssmsap.model.Operation;

public class ListOperationsIterable
implements SdkIterable<ListOperationsResponse> {
    private final SsmSapClient client;
    private final ListOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOperationsIterable(SsmSapClient client, ListOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public Iterator<ListOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Operation> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOperationsResponseFetcher
    implements SyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOperationsResponse nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsIterable.this.client.listOperations(ListOperationsIterable.this.firstRequest);
            }
            return ListOperationsIterable.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

