/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse;
import software.amazon.awssdk.services.ssm.model.InstanceProperty;

public class DescribeInstancePropertiesPublisher
implements SdkPublisher<DescribeInstancePropertiesResponse> {
    private final SsmAsyncClient client;
    private final DescribeInstancePropertiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstancePropertiesPublisher(SsmAsyncClient client, DescribeInstancePropertiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstancePropertiesPublisher(SsmAsyncClient client, DescribeInstancePropertiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstancePropertiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstancePropertiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceProperty> instanceProperties() {
        Function<DescribeInstancePropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProperties() != null) {
                return response.instanceProperties().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstancePropertiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstancePropertiesResponseFetcher
    implements AsyncPageFetcher<DescribeInstancePropertiesResponse> {
        private DescribeInstancePropertiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstancePropertiesResponse> nextPage(DescribeInstancePropertiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePropertiesPublisher.this.client.describeInstanceProperties(DescribeInstancePropertiesPublisher.this.firstRequest);
            }
            return DescribeInstancePropertiesPublisher.this.client.describeInstanceProperties((DescribeInstancePropertiesRequest)((Object)DescribeInstancePropertiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

