/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Parameter.getter(Parameter::name)).setter(Parameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Parameter.getter(Parameter::typeAsString)).setter(Parameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Parameter.getter(Parameter::value)).setter(Parameter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(Parameter.getter(Parameter::version)).setter(Parameter.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Selector").getter(Parameter.getter(Parameter::selector)).setter(Parameter.setter(Builder::selector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()}).build();
    private static final SdkField<String> SOURCE_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResult").getter(Parameter.getter(Parameter::sourceResult)).setter(Parameter.setter(Builder::sourceResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResult").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(Parameter.getter(Parameter::lastModifiedDate)).setter(Parameter.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(Parameter.getter(Parameter::arn)).setter(Parameter.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(Parameter.getter(Parameter::dataType)).setter(Parameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, VALUE_FIELD, VERSION_FIELD, SELECTOR_FIELD, SOURCE_RESULT_FIELD, LAST_MODIFIED_DATE_FIELD, ARN_FIELD, DATA_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Parameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String value;
    private final Long version;
    private final String selector;
    private final String sourceResult;
    private final Instant lastModifiedDate;
    private final String arn;
    private final String dataType;

    private Parameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.version = builder.version;
        this.selector = builder.selector;
        this.sourceResult = builder.sourceResult;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.arn = builder.arn;
        this.dataType = builder.dataType;
    }

    public final String name() {
        return this.name;
    }

    public final ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String value() {
        return this.value;
    }

    public final Long version() {
        return this.version;
    }

    public final String selector() {
        return this.selector;
    }

    public final String sourceResult() {
        return this.sourceResult;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String arn() {
        return this.arn;
    }

    public final String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.selector(), other.selector()) && Objects.equals(this.sourceResult(), other.sourceResult()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataType(), other.dataType());
    }

    public final String toString() {
        return ToString.builder((String)"Parameter").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("Version", (Object)this.version()).add("Selector", (Object)this.selector()).add("SourceResult", (Object)this.sourceResult()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("ARN", (Object)this.arn()).add("DataType", (Object)this.dataType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
            case "SourceResult": {
                return Optional.ofNullable(clazz.cast(this.sourceResult()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("SourceResult", SOURCE_RESULT_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("DataType", DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String value;
        private Long version;
        private String selector;
        private String sourceResult;
        private Instant lastModifiedDate;
        private String arn;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.name(model.name);
            this.type(model.type);
            this.value(model.value);
            this.version(model.version);
            this.selector(model.selector);
            this.sourceResult(model.sourceResult);
            this.lastModifiedDate(model.lastModifiedDate);
            this.arn(model.arn);
            this.dataType(model.dataType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getSelector() {
            return this.selector;
        }

        public final void setSelector(String selector) {
            this.selector = selector;
        }

        @Override
        public final Builder selector(String selector) {
            this.selector = selector;
            return this;
        }

        public final String getSourceResult() {
            return this.sourceResult;
        }

        public final void setSourceResult(String sourceResult) {
            this.sourceResult = sourceResult;
        }

        @Override
        public final Builder sourceResult(String sourceResult) {
            this.sourceResult = sourceResult;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder value(String var1);

        public Builder version(Long var1);

        public Builder selector(String var1);

        public Builder sourceResult(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder arn(String var1);

        public Builder dataType(String var1);
    }
}

