/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpsItemRelatedItemsRequest extends SsmRequest implements
        ToCopyableBuilder<ListOpsItemRelatedItemsRequest.Builder, ListOpsItemRelatedItemsRequest> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(ListOpsItemRelatedItemsRequest::opsItemId)).setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<List<OpsItemRelatedItemsFilter>> FILTERS_FIELD = SdkField
            .<List<OpsItemRelatedItemsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListOpsItemRelatedItemsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsItemRelatedItemsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsItemRelatedItemsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListOpsItemRelatedItemsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOpsItemRelatedItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String opsItemId;

    private final List<OpsItemRelatedItemsFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListOpsItemRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.opsItemId = builder.opsItemId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the OpsItem for which you want to list all related-item resources.
     * </p>
     * 
     * @return The ID of the OpsItem for which you want to list all related-item resources.
     */
    public final String opsItemId() {
        return opsItemId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more OpsItem filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more OpsItem filters. Use a filter to return a more specific list of results.
     */
    public final List<OpsItemRelatedItemsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpsItemRelatedItemsRequest)) {
            return false;
        }
        ListOpsItemRelatedItemsRequest other = (ListOpsItemRelatedItemsRequest) obj;
        return Objects.equals(opsItemId(), other.opsItemId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpsItemRelatedItemsRequest").add("OpsItemId", opsItemId())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpsItemId", OPS_ITEM_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpsItemRelatedItemsRequest, T> g) {
        return obj -> g.apply((ListOpsItemRelatedItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOpsItemRelatedItemsRequest> {
        /**
         * <p>
         * The ID of the OpsItem for which you want to list all related-item resources.
         * </p>
         * 
         * @param opsItemId
         *        The ID of the OpsItem for which you want to list all related-item resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * One or more OpsItem filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more OpsItem filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OpsItemRelatedItemsFilter> filters);

        /**
         * <p>
         * One or more OpsItem filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more OpsItem filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OpsItemRelatedItemsFilter... filters);

        /**
         * <p>
         * One or more OpsItem filters. Use a filter to return a more specific list of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<OpsItemRelatedItemsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<OpsItemRelatedItemsFilter>)
         */
        Builder filters(Consumer<OpsItemRelatedItemsFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String opsItemId;

        private List<OpsItemRelatedItemsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpsItemRelatedItemsRequest model) {
            super(model);
            opsItemId(model.opsItemId);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final List<OpsItemRelatedItemsFilter.Builder> getFilters() {
            List<OpsItemRelatedItemsFilter.Builder> result = OpsItemRelatedItemsFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OpsItemRelatedItemsFilter.BuilderImpl> filters) {
            this.filters = OpsItemRelatedItemsFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<OpsItemRelatedItemsFilter> filters) {
            this.filters = OpsItemRelatedItemsFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OpsItemRelatedItemsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OpsItemRelatedItemsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OpsItemRelatedItemsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOpsItemRelatedItemsRequest build() {
            return new ListOpsItemRelatedItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
