/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the CloudWatch alarm you want to apply to an automation or command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmConfiguration.Builder, AlarmConfiguration> {
    private static final SdkField<Boolean> IGNORE_POLL_ALARM_FAILURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnorePollAlarmFailure").getter(getter(AlarmConfiguration::ignorePollAlarmFailure))
            .setter(setter(Builder::ignorePollAlarmFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnorePollAlarmFailure").build())
            .build();

    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField
            .<List<Alarm>> builder(MarshallingType.LIST)
            .memberName("Alarms")
            .getter(getter(AlarmConfiguration::alarms))
            .setter(setter(Builder::alarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Alarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(Alarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IGNORE_POLL_ALARM_FAILURE_FIELD, ALARMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean ignorePollAlarmFailure;

    private final List<Alarm> alarms;

    private AlarmConfiguration(BuilderImpl builder) {
        this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * When this value is <i>true</i>, your automation or command continues to run in cases where we can’t retrieve
     * alarm status information from CloudWatch. In cases where we successfully retrieve an alarm status of OK or
     * INSUFFICIENT_DATA, the automation or command continues to run, regardless of this value. Default is <i>false</i>.
     * </p>
     * 
     * @return When this value is <i>true</i>, your automation or command continues to run in cases where we can’t
     *         retrieve alarm status information from CloudWatch. In cases where we successfully retrieve an alarm
     *         status of OK or INSUFFICIENT_DATA, the automation or command continues to run, regardless of this value.
     *         Default is <i>false</i>.
     */
    public final Boolean ignorePollAlarmFailure() {
        return ignorePollAlarmFailure;
    }

    /**
     * For responses, this returns true if the service returned a value for the Alarms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarms() {
        return alarms != null && !(alarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the CloudWatch alarm specified in the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarms} method.
     * </p>
     * 
     * @return The name of the CloudWatch alarm specified in the configuration.
     */
    public final List<Alarm> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ignorePollAlarmFailure());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarms() ? alarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration) obj;
        return Objects.equals(ignorePollAlarmFailure(), other.ignorePollAlarmFailure()) && hasAlarms() == other.hasAlarms()
                && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmConfiguration").add("IgnorePollAlarmFailure", ignorePollAlarmFailure())
                .add("Alarms", hasAlarms() ? alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IgnorePollAlarmFailure":
            return Optional.ofNullable(clazz.cast(ignorePollAlarmFailure()));
        case "Alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IgnorePollAlarmFailure", IGNORE_POLL_ALARM_FAILURE_FIELD);
        map.put("Alarms", ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmConfiguration, T> g) {
        return obj -> g.apply((AlarmConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmConfiguration> {
        /**
         * <p>
         * When this value is <i>true</i>, your automation or command continues to run in cases where we can’t retrieve
         * alarm status information from CloudWatch. In cases where we successfully retrieve an alarm status of OK or
         * INSUFFICIENT_DATA, the automation or command continues to run, regardless of this value. Default is
         * <i>false</i>.
         * </p>
         * 
         * @param ignorePollAlarmFailure
         *        When this value is <i>true</i>, your automation or command continues to run in cases where we can’t
         *        retrieve alarm status information from CloudWatch. In cases where we successfully retrieve an alarm
         *        status of OK or INSUFFICIENT_DATA, the automation or command continues to run, regardless of this
         *        value. Default is <i>false</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure);

        /**
         * <p>
         * The name of the CloudWatch alarm specified in the configuration.
         * </p>
         * 
         * @param alarms
         *        The name of the CloudWatch alarm specified in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * The name of the CloudWatch alarm specified in the configuration.
         * </p>
         * 
         * @param alarms
         *        The name of the CloudWatch alarm specified in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);

        /**
         * <p>
         * The name of the CloudWatch alarm specified in the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Alarm.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Alarm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Alarm.Builder#build()}
         * is called immediately and its result is passed to {@link #alarms(List<Alarm>)}.
         * 
         * @param alarms
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Alarm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(java.util.Collection<Alarm>)
         */
        Builder alarms(Consumer<Alarm.Builder>... alarms);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ignorePollAlarmFailure;

        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmConfiguration model) {
            ignorePollAlarmFailure(model.ignorePollAlarmFailure);
            alarms(model.alarms);
        }

        public final Boolean getIgnorePollAlarmFailure() {
            return ignorePollAlarmFailure;
        }

        public final void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
        }

        @Override
        public final Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public final List<Alarm.Builder> getAlarms() {
            List<Alarm.Builder> result = AlarmListCopier.copyToBuilder(this.alarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmListCopier.copyFromBuilder(alarms);
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder>... alarms) {
            alarms(Stream.of(alarms).map(c -> Alarm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AlarmConfiguration build() {
            return new AlarmConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
