/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a managed node's type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeType implements SdkPojo, Serializable, ToCopyableBuilder<NodeType.Builder, NodeType> {
    private static final SdkField<InstanceInfo> INSTANCE_FIELD = SdkField.<InstanceInfo> builder(MarshallingType.SDK_POJO)
            .memberName("Instance").getter(getter(NodeType::instance)).setter(setter(Builder::instance))
            .constructor(InstanceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceInfo instance;

    private final Type type;

    private NodeType(BuilderImpl builder) {
        this.instance = builder.instance;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a specific managed node.
     * </p>
     * 
     * @return Information about a specific managed node.
     */
    public final InstanceInfo instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeType)) {
            return false;
        }
        NodeType other = (NodeType) obj;
        return Objects.equals(instance(), other.instance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeType").add("Instance", instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #instance()} initialized to the given value.
     *
     * <p>
     * Information about a specific managed node.
     * </p>
     * 
     * @param instance
     *        Information about a specific managed node.
     */
    public static NodeType fromInstance(InstanceInfo instance) {
        return builder().instance(instance).build();
    }

    /**
     * Create an instance of this class with {@link #instance()} initialized to the given value.
     *
     * <p>
     * Information about a specific managed node.
     * </p>
     * 
     * @param instance
     *        Information about a specific managed node.
     */
    public static NodeType fromInstance(Consumer<InstanceInfo.Builder> instance) {
        InstanceInfo.Builder builder = InstanceInfo.builder();
        instance.accept(builder);
        return fromInstance(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Instance", INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeType, T> g) {
        return obj -> g.apply((NodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeType> {
        /**
         * <p>
         * Information about a specific managed node.
         * </p>
         * 
         * @param instance
         *        Information about a specific managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(InstanceInfo instance);

        /**
         * <p>
         * Information about a specific managed node.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceInfo.Builder} avoiding the need
         * to create one manually via {@link InstanceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #instance(InstanceInfo)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link InstanceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(InstanceInfo)
         */
        default Builder instance(Consumer<InstanceInfo.Builder> instance) {
            return instance(InstanceInfo.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceInfo instance;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NodeType model) {
            instance(model.instance);
        }

        public final InstanceInfo.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(InstanceInfo.BuilderImpl instance) {
            Object oldValue = this.instance;
            this.instance = instance != null ? instance.build() : null;
            handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
        }

        @Override
        public final Builder instance(InstanceInfo instance) {
            Object oldValue = this.instance;
            this.instance = instance;
            handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
            return this;
        }

        @Override
        public NodeType build() {
            return new NodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NodeType#type()
     */
    public enum Type {
        INSTANCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
