/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInventorySchemaRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetInventorySchemaRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(GetInventorySchemaRequest.getter(GetInventorySchemaRequest::typeName)).setter(GetInventorySchemaRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInventorySchemaRequest.getter(GetInventorySchemaRequest::nextToken)).setter(GetInventorySchemaRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetInventorySchemaRequest.getter(GetInventorySchemaRequest::maxResults)).setter(GetInventorySchemaRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> AGGREGATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Aggregator").getter(GetInventorySchemaRequest.getter(GetInventorySchemaRequest::aggregator)).setter(GetInventorySchemaRequest.setter(Builder::aggregator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregator").build()}).build();
    private static final SdkField<Boolean> SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SubType").getter(GetInventorySchemaRequest.getter(GetInventorySchemaRequest::subType)).setter(GetInventorySchemaRequest.setter(Builder::subType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, AGGREGATOR_FIELD, SUB_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInventorySchemaRequest.memberNameToFieldInitializer();
    private final String typeName;
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean aggregator;
    private final Boolean subType;

    private GetInventorySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.aggregator = builder.aggregator;
        this.subType = builder.subType;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean aggregator() {
        return this.aggregator;
    }

    public final Boolean subType() {
        return this.subType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregator());
        hashCode = 31 * hashCode + Objects.hashCode(this.subType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaRequest)) {
            return false;
        }
        GetInventorySchemaRequest other = (GetInventorySchemaRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.aggregator(), other.aggregator()) && Objects.equals(this.subType(), other.subType());
    }

    public final String toString() {
        return ToString.builder((String)"GetInventorySchemaRequest").add("TypeName", (Object)this.typeName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Aggregator", (Object)this.aggregator()).add("SubType", (Object)this.subType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Aggregator": {
                return Optional.ofNullable(clazz.cast(this.aggregator()));
            }
            case "SubType": {
                return Optional.ofNullable(clazz.cast(this.subType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Aggregator", AGGREGATOR_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInventorySchemaRequest, T> g) {
        return obj -> g.apply((GetInventorySchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String nextToken;
        private Integer maxResults;
        private Boolean aggregator;
        private Boolean subType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaRequest model) {
            super(model);
            this.typeName(model.typeName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.aggregator(model.aggregator);
            this.subType(model.subType);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getAggregator() {
            return this.aggregator;
        }

        public final void setAggregator(Boolean aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public final Builder aggregator(Boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public final Boolean getSubType() {
            return this.subType;
        }

        public final void setSubType(Boolean subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(Boolean subType) {
            this.subType = subType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInventorySchemaRequest build() {
            return new GetInventorySchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInventorySchemaRequest> {
        public Builder typeName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder aggregator(Boolean var1);

        public Builder subType(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

