/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the source where the association execution details are stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSource implements SdkPojo, Serializable, ToCopyableBuilder<OutputSource.Builder, OutputSource> {
    private static final SdkField<String> OUTPUT_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSourceId").getter(getter(OutputSource::outputSourceId)).setter(setter(Builder::outputSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSourceId").build()).build();

    private static final SdkField<String> OUTPUT_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSourceType").getter(getter(OutputSource::outputSourceType))
            .setter(setter(Builder::outputSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SOURCE_ID_FIELD,
            OUTPUT_SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputSourceId;

    private final String outputSourceType;

    private OutputSource(BuilderImpl builder) {
        this.outputSourceId = builder.outputSourceId;
        this.outputSourceType = builder.outputSourceType;
    }

    /**
     * <p>
     * The ID of the output source, for example the URL of an S3 bucket.
     * </p>
     * 
     * @return The ID of the output source, for example the URL of an S3 bucket.
     */
    public final String outputSourceId() {
        return outputSourceId;
    }

    /**
     * <p>
     * The type of source where the association execution details are stored, for example, Amazon S3.
     * </p>
     * 
     * @return The type of source where the association execution details are stored, for example, Amazon S3.
     */
    public final String outputSourceType() {
        return outputSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(outputSourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSource)) {
            return false;
        }
        OutputSource other = (OutputSource) obj;
        return Objects.equals(outputSourceId(), other.outputSourceId())
                && Objects.equals(outputSourceType(), other.outputSourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputSource").add("OutputSourceId", outputSourceId())
                .add("OutputSourceType", outputSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputSourceId":
            return Optional.ofNullable(clazz.cast(outputSourceId()));
        case "OutputSourceType":
            return Optional.ofNullable(clazz.cast(outputSourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputSourceId", OUTPUT_SOURCE_ID_FIELD);
        map.put("OutputSourceType", OUTPUT_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputSource, T> g) {
        return obj -> g.apply((OutputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSource> {
        /**
         * <p>
         * The ID of the output source, for example the URL of an S3 bucket.
         * </p>
         * 
         * @param outputSourceId
         *        The ID of the output source, for example the URL of an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceId(String outputSourceId);

        /**
         * <p>
         * The type of source where the association execution details are stored, for example, Amazon S3.
         * </p>
         * 
         * @param outputSourceType
         *        The type of source where the association execution details are stored, for example, Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceType(String outputSourceType);
    }

    static final class BuilderImpl implements Builder {
        private String outputSourceId;

        private String outputSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSource model) {
            outputSourceId(model.outputSourceId);
            outputSourceType(model.outputSourceType);
        }

        public final String getOutputSourceId() {
            return outputSourceId;
        }

        public final void setOutputSourceId(String outputSourceId) {
            this.outputSourceId = outputSourceId;
        }

        @Override
        public final Builder outputSourceId(String outputSourceId) {
            this.outputSourceId = outputSourceId;
            return this;
        }

        public final String getOutputSourceType() {
            return outputSourceType;
        }

        public final void setOutputSourceType(String outputSourceType) {
            this.outputSourceType = outputSourceType;
        }

        @Override
        public final Builder outputSourceType(String outputSourceType) {
            this.outputSourceType = outputSourceType;
            return this;
        }

        @Override
        public OutputSource build() {
            return new OutputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
