/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentParameterType {
    STRING("String"),
    STRING_LIST("StringList"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentParameterType> VALUE_MAP;
    private final String value;

    private DocumentParameterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentParameterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentParameterType> knownValues() {
        EnumSet<DocumentParameterType> knownValues = EnumSet.allOf(DocumentParameterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentParameterType.class, DocumentParameterType::toString);
    }
}

