/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMaintenanceWindowTaskRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateMaintenanceWindowTaskRequest.Builder, UpdateMaintenanceWindowTaskRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowId").getter(getter(UpdateMaintenanceWindowTaskRequest::windowId))
            .setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> WINDOW_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowTaskId").getter(getter(UpdateMaintenanceWindowTaskRequest::windowTaskId))
            .setter(setter(Builder::windowTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTaskId").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(UpdateMaintenanceWindowTaskRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(UpdateMaintenanceWindowTaskRequest::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRoleArn").getter(getter(UpdateMaintenanceWindowTaskRequest::serviceRoleArn))
            .setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<Map<String, MaintenanceWindowTaskParameterValueExpression>> TASK_PARAMETERS_FIELD = SdkField
            .<Map<String, MaintenanceWindowTaskParameterValueExpression>> builder(MarshallingType.MAP)
            .memberName("TaskParameters")
            .getter(getter(UpdateMaintenanceWindowTaskRequest::taskParameters))
            .setter(setter(Builder::taskParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MaintenanceWindowTaskParameterValueExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowTaskParameterValueExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MaintenanceWindowTaskInvocationParameters> TASK_INVOCATION_PARAMETERS_FIELD = SdkField
            .<MaintenanceWindowTaskInvocationParameters> builder(MarshallingType.SDK_POJO).memberName("TaskInvocationParameters")
            .getter(getter(UpdateMaintenanceWindowTaskRequest::taskInvocationParameters))
            .setter(setter(Builder::taskInvocationParameters)).constructor(MaintenanceWindowTaskInvocationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInvocationParameters").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(UpdateMaintenanceWindowTaskRequest::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(UpdateMaintenanceWindowTaskRequest::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(UpdateMaintenanceWindowTaskRequest::maxErrors))
            .setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(UpdateMaintenanceWindowTaskRequest::loggingInfo))
            .setter(setter(Builder::loggingInfo)).constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingInfo").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateMaintenanceWindowTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateMaintenanceWindowTaskRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Replace").getter(getter(UpdateMaintenanceWindowTaskRequest::replace)).setter(setter(Builder::replace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()).build();

    private static final SdkField<String> CUTOFF_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CutoffBehavior").getter(getter(UpdateMaintenanceWindowTaskRequest::cutoffBehaviorAsString))
            .setter(setter(Builder::cutoffBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CutoffBehavior").build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("AlarmConfiguration")
            .getter(getter(UpdateMaintenanceWindowTaskRequest::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD,
            WINDOW_TASK_ID_FIELD, TARGETS_FIELD, TASK_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, TASK_PARAMETERS_FIELD,
            TASK_INVOCATION_PARAMETERS_FIELD, PRIORITY_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, LOGGING_INFO_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, REPLACE_FIELD, CUTOFF_BEHAVIOR_FIELD, ALARM_CONFIGURATION_FIELD));

    private final String windowId;

    private final String windowTaskId;

    private final List<Target> targets;

    private final String taskArn;

    private final String serviceRoleArn;

    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

    private final Integer priority;

    private final String maxConcurrency;

    private final String maxErrors;

    private final LoggingInfo loggingInfo;

    private final String name;

    private final String description;

    private final Boolean replace;

    private final String cutoffBehavior;

    private final AlarmConfiguration alarmConfiguration;

    private UpdateMaintenanceWindowTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
        this.replace = builder.replace;
        this.cutoffBehavior = builder.cutoffBehavior;
        this.alarmConfiguration = builder.alarmConfiguration;
    }

    /**
     * <p>
     * The maintenance window ID that contains the task to modify.
     * </p>
     * 
     * @return The maintenance window ID that contains the task to modify.
     */
    public final String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The task ID to modify.
     * </p>
     * 
     * @return The task ID to modify.
     */
    public final String windowTaskId() {
        return windowTaskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
     * <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
     * <code> Key=tag_name,Values=tag_value</code>.
     * </p>
     * <note>
     * <p>
     * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
     * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more
     * information about running tasks that don't specify targets, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
     *         <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
     *         <code> Key=tag_name,Values=tag_value</code>. </p> <note>
     *         <p>
     *         One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the
     *         task, targets are optional for other maintenance window task types (Automation, Lambda, and Step
     *         Functions). For more information about running tasks that don't specify targets, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     *         >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager
     *         User Guide</i>.
     *         </p>
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The task ARN to modify.
     * </p>
     * 
     * @return The task ARN to modify.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when
     * running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's
     * service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you
     * run <code>RegisterTaskWithMaintenanceWindow</code>.
     * </p>
     * <p>
     * For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User
     * Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions"
     * >Using service-linked roles for Systems Manager</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role"
     * >Should I use a service-linked role or a custom service role to run maintenance window tasks? </a>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume
     *         when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses
     *         your account's service-linked role. If no service-linked role for Systems Manager exists in your account,
     *         it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p>
     *         <p>
     *         For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions"
     *         >Using service-linked roles for Systems Manager</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role"
     *         >Should I use a service-linked role or a custom service role to run maintenance window tasks? </a>
     *         </p>
     *         </li>
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskParameters() {
        return taskParameters != null && !(taskParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters to modify.
     * </p>
     * <note>
     * <p>
     * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead
     * use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task types, see
     * <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * </note>
     * <p>
     * The map has the following format:
     * </p>
     * <p>
     * Key: string, between 1 and 255 characters
     * </p>
     * <p>
     * Value: an array of strings, each string is between 1 and 255 characters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskParameters} method.
     * </p>
     * 
     * @return The parameters to modify.</p> <note>
     *         <p>
     *         <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
     *         instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
     *         For information about how Systems Manager handles these options for the supported maintenance window task
     *         types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     *         </note>
     *         <p>
     *         The map has the following format:
     *         </p>
     *         <p>
     *         Key: string, between 1 and 255 characters
     *         </p>
     *         <p>
     *         Value: an array of strings, each string is between 1 and 255 characters
     */
    public final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return taskParameters;
    }

    /**
     * <p>
     * The parameters that the task should use during execution. Populate only the fields that match the task type. All
     * other fields should be empty.
     * </p>
     * <important>
     * <p>
     * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>,
     * you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values
     * you don't specify again are removed. For example, suppose that when you registered a Run Command task, you
     * specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>,
     * and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different
     * <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code>
     * are removed.
     * </p>
     * </important>
     * 
     * @return The parameters that the task should use during execution. Populate only the fields that match the task
     *         type. All other fields should be empty.</p> <important>
     *         <p>
     *         When you update a maintenance window task that has options specified in
     *         <code>TaskInvocationParameters</code>, you must provide again all the
     *         <code>TaskInvocationParameters</code> values that you want to retain. The values you don't specify again
     *         are removed. For example, suppose that when you registered a Run Command task, you specified
     *         <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>,
     *         and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a
     *         different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and
     *         <code>NotificationConfig</code> are removed.
     *         </p>
     */
    public final MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return taskInvocationParameters;
    }

    /**
     * <p>
     * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
     * priority are scheduled in parallel.
     * </p>
     * 
     * @return The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
     *         priority are scheduled in parallel.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of
     * targets that are allowed to run this task, in parallel.
     * </p>
     * <note>
     * <p>
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or
     * updating a <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     * >targetless task</a> You must provide a value in all other cases.
     * </p>
     * <p>
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the
     * system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.
     * </p>
     * </note>
     * 
     * @return The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number
     *         of targets that are allowed to run this task, in parallel.</p> <note>
     *         <p>
     *         Although this element is listed as "Required: No", a value can be omitted only when you are registering
     *         or updating a <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     *         >targetless task</a> You must provide a value in all other cases.
     *         </p>
     *         <p>
     *         For maintenance window tasks without a target specified, you can't supply a value for this option.
     *         Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running
     *         of your task.
     *         </p>
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that are
     * allowed before the task stops being scheduled.
     * </p>
     * <note>
     * <p>
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or
     * updating a <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     * >targetless task</a> You must provide a value in all other cases.
     * </p>
     * <p>
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the
     * system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.
     * </p>
     * </note>
     * 
     * @return The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors
     *         that are allowed before the task stops being scheduled.</p> <note>
     *         <p>
     *         Although this element is listed as "Required: No", a value can be omitted only when you are registering
     *         or updating a <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     *         >targetless task</a> You must provide a value in all other cases.
     *         </p>
     *         <p>
     *         For maintenance window tasks without a target specified, you can't supply a value for this option.
     *         Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running
     *         of your task.
     *         </p>
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The new logging location in Amazon S3 to specify.
     * </p>
     * <note>
     * <p>
     * <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to
     * contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
     * <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager
     * handles these options for the supported maintenance window task types, see
     * <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * </note>
     * 
     * @return The new logging location in Amazon S3 to specify.</p> <note>
     *         <p>
     *         <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3)
     *         bucket to contain logs, instead use the <code>OutputS3BucketName</code> and
     *         <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For
     *         information about how Amazon Web Services Systems Manager handles these options for the supported
     *         maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     * <p>
     * The new task name to specify.
     * </p>
     * 
     * @return The new task name to specify.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new task description to specify.
     * </p>
     * 
     * @return The new task description to specify.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are also
     * required for this API request. Optional fields that aren't specified are set to null.
     * </p>
     * 
     * @return If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are
     *         also required for this API request. Optional fields that aren't specified are set to null.
     */
    public final Boolean replace() {
        return replace;
    }

    /**
     * <p>
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is
     * reached.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_TASK</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are
     * already running continue, but no new task invocations are started.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that
     * attempts to cancel the command associated with the task. However, there is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The status for tasks that are not completed is <code>TIMED_OUT</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cutoffBehavior}
     * will return {@link MaintenanceWindowTaskCutoffBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #cutoffBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows
     *         is reached. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The
     *         default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_TASK</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that
     *         are already running continue, but no new task invocations are started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation
     *         that attempts to cancel the command associated with the task. However, there is no guarantee that the
     *         command will be terminated and the underlying process stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The status for tasks that are not completed is <code>TIMED_OUT</code>.
     *         </p>
     *         </li>
     * @see MaintenanceWindowTaskCutoffBehavior
     */
    public final MaintenanceWindowTaskCutoffBehavior cutoffBehavior() {
        return MaintenanceWindowTaskCutoffBehavior.fromValue(cutoffBehavior);
    }

    /**
     * <p>
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is
     * reached.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_TASK</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are
     * already running continue, but no new task invocations are started.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that
     * attempts to cancel the command associated with the task. However, there is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The status for tasks that are not completed is <code>TIMED_OUT</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cutoffBehavior}
     * will return {@link MaintenanceWindowTaskCutoffBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #cutoffBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows
     *         is reached. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The
     *         default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_TASK</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that
     *         are already running continue, but no new task invocations are started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation
     *         that attempts to cancel the command associated with the task. However, there is no guarantee that the
     *         command will be terminated and the underlying process stopped.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The status for tasks that are not completed is <code>TIMED_OUT</code>.
     *         </p>
     *         </li>
     * @see MaintenanceWindowTaskCutoffBehavior
     */
    public final String cutoffBehaviorAsString() {
        return cutoffBehavior;
    }

    /**
     * <p>
     * The CloudWatch alarm you want to apply to your maintenance window task.
     * </p>
     * 
     * @return The CloudWatch alarm you want to apply to your maintenance window task.
     */
    public final AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskParameters() ? taskParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        hashCode = 31 * hashCode + Objects.hashCode(cutoffBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTaskRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTaskRequest other = (UpdateMaintenanceWindowTaskRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(taskArn(), other.taskArn()) && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && hasTaskParameters() == other.hasTaskParameters() && Objects.equals(taskParameters(), other.taskParameters())
                && Objects.equals(taskInvocationParameters(), other.taskInvocationParameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(maxErrors(), other.maxErrors()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(replace(), other.replace())
                && Objects.equals(cutoffBehaviorAsString(), other.cutoffBehaviorAsString())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMaintenanceWindowTaskRequest").add("WindowId", windowId())
                .add("WindowTaskId", windowTaskId()).add("Targets", hasTargets() ? targets() : null).add("TaskArn", taskArn())
                .add("ServiceRoleArn", serviceRoleArn())
                .add("TaskParameters", taskParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TaskInvocationParameters", taskInvocationParameters()).add("Priority", priority())
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors()).add("LoggingInfo", loggingInfo())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Replace", replace()).add("CutoffBehavior", cutoffBehaviorAsString())
                .add("AlarmConfiguration", alarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.ofNullable(clazz.cast(windowTaskId()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "TaskParameters":
            return Optional.ofNullable(clazz.cast(taskParameters()));
        case "TaskInvocationParameters":
            return Optional.ofNullable(clazz.cast(taskInvocationParameters()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Replace":
            return Optional.ofNullable(clazz.cast(replace()));
        case "CutoffBehavior":
            return Optional.ofNullable(clazz.cast(cutoffBehaviorAsString()));
        case "AlarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceWindowTaskRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceWindowTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMaintenanceWindowTaskRequest> {
        /**
         * <p>
         * The maintenance window ID that contains the task to modify.
         * </p>
         * 
         * @param windowId
         *        The maintenance window ID that contains the task to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The task ID to modify.
         * </p>
         * 
         * @param windowTaskId
         *        The task ID to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);

        /**
         * <p>
         * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
         * <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
         * <code> Key=tag_name,Values=tag_value</code>.
         * </p>
         * <note>
         * <p>
         * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
         * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For
         * more information about running tasks that don't specify targets, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param targets
         *        The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
         *        <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
         *        <code> Key=tag_name,Values=tag_value</code>. </p> <note>
         *        <p>
         *        One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the
         *        task, targets are optional for other maintenance window task types (Automation, Lambda, and Step
         *        Functions). For more information about running tasks that don't specify targets, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         *        >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems
         *        Manager User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
         * <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
         * <code> Key=tag_name,Values=tag_value</code>.
         * </p>
         * <note>
         * <p>
         * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
         * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For
         * more information about running tasks that don't specify targets, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param targets
         *        The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
         *        <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
         *        <code> Key=tag_name,Values=tag_value</code>. </p> <note>
         *        <p>
         *        One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the
         *        task, targets are optional for other maintenance window task types (Automation, Lambda, and Step
         *        Functions). For more information about running tasks that don't specify targets, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         *        >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems
         *        Manager User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format
         * <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format
         * <code> Key=tag_name,Values=tag_value</code>.
         * </p>
         * <note>
         * <p>
         * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
         * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For
         * more information about running tasks that don't specify targets, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Target.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Target.Builder#build()}
         * is called immediately and its result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The task ARN to modify.
         * </p>
         * 
         * @param taskArn
         *        The task ARN to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when
         * running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your
         * account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is
         * created when you run <code>RegisterTaskWithMaintenanceWindow</code>.
         * </p>
         * <p>
         * For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User
         * Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions"
         * >Using service-linked roles for Systems Manager</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role"
         * >Should I use a service-linked role or a custom service role to run maintenance window tasks? </a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to
         *        assume when running a maintenance window task. If you do not specify a service role ARN, Systems
         *        Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists
         *        in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p>
         *        <p>
         *        For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager
         *        User Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions"
         *        >Using service-linked roles for Systems Manager</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role"
         *        >Should I use a service-linked role or a custom service role to run maintenance window tasks? </a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The parameters to modify.
         * </p>
         * <note>
         * <p>
         * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For
         * information about how Systems Manager handles these options for the supported maintenance window task types,
         * see <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note>
         * <p>
         * The map has the following format:
         * </p>
         * <p>
         * Key: string, between 1 and 255 characters
         * </p>
         * <p>
         * Value: an array of strings, each string is between 1 and 255 characters
         * </p>
         * 
         * @param taskParameters
         *        The parameters to modify.</p> <note>
         *        <p>
         *        <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         *        instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
         *        For information about how Systems Manager handles these options for the supported maintenance window
         *        task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         *        </note>
         *        <p>
         *        The map has the following format:
         *        </p>
         *        <p>
         *        Key: string, between 1 and 255 characters
         *        </p>
         *        <p>
         *        Value: an array of strings, each string is between 1 and 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters);

        /**
         * <p>
         * The parameters that the task should use during execution. Populate only the fields that match the task type.
         * All other fields should be empty.
         * </p>
         * <important>
         * <p>
         * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>
         * , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The
         * values you don't specify again are removed. For example, suppose that when you registered a Run Command task,
         * you specified <code>TaskInvocationParameters</code> values for <code>Comment</code>,
         * <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the maintenance window
         * task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code>
         * and <code>NotificationConfig</code> are removed.
         * </p>
         * </important>
         * 
         * @param taskInvocationParameters
         *        The parameters that the task should use during execution. Populate only the fields that match the task
         *        type. All other fields should be empty.</p> <important>
         *        <p>
         *        When you update a maintenance window task that has options specified in
         *        <code>TaskInvocationParameters</code>, you must provide again all the
         *        <code>TaskInvocationParameters</code> values that you want to retain. The values you don't specify
         *        again are removed. For example, suppose that when you registered a Run Command task, you specified
         *        <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>
         *        , and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a
         *        different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and
         *        <code>NotificationConfig</code> are removed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters);

        /**
         * <p>
         * The parameters that the task should use during execution. Populate only the fields that match the task type.
         * All other fields should be empty.
         * </p>
         * <important>
         * <p>
         * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>
         * , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The
         * values you don't specify again are removed. For example, suppose that when you registered a Run Command task,
         * you specified <code>TaskInvocationParameters</code> values for <code>Comment</code>,
         * <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the maintenance window
         * task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code>
         * and <code>NotificationConfig</code> are removed.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link MaintenanceWindowTaskInvocationParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowTaskInvocationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindowTaskInvocationParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)}.
         * 
         * @param taskInvocationParameters
         *        a consumer that will call methods on {@link MaintenanceWindowTaskInvocationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)
         */
        default Builder taskInvocationParameters(
                Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return taskInvocationParameters(MaintenanceWindowTaskInvocationParameters.builder()
                    .applyMutation(taskInvocationParameters).build());
        }

        /**
         * <p>
         * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
         * priority are scheduled in parallel.
         * </p>
         * 
         * @param priority
         *        The new task priority to specify. The lower the number, the higher the priority. Tasks that have the
         *        same priority are scheduled in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of
         * targets that are allowed to run this task, in parallel.
         * </p>
         * <note>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or
         * updating a <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         * >targetless task</a> You must provide a value in all other cases.
         * </p>
         * <p>
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead,
         * the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.
         * </p>
         * </note>
         * 
         * @param maxConcurrency
         *        The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the
         *        number of targets that are allowed to run this task, in parallel.</p> <note>
         *        <p>
         *        Although this element is listed as "Required: No", a value can be omitted only when you are
         *        registering or updating a <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         *        >targetless task</a> You must provide a value in all other cases.
         *        </p>
         *        <p>
         *        For maintenance window tasks without a target specified, you can't supply a value for this option.
         *        Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the
         *        running of your task.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that
         * are allowed before the task stops being scheduled.
         * </p>
         * <note>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or
         * updating a <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         * >targetless task</a> You must provide a value in all other cases.
         * </p>
         * <p>
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead,
         * the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.
         * </p>
         * </note>
         * 
         * @param maxErrors
         *        The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of
         *        errors that are allowed before the task stops being scheduled.</p> <note>
         *        <p>
         *        Although this element is listed as "Required: No", a value can be omitted only when you are
         *        registering or updating a <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
         *        >targetless task</a> You must provide a value in all other cases.
         *        </p>
         *        <p>
         *        For maintenance window tasks without a target specified, you can't supply a value for this option.
         *        Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the
         *        running of your task.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The new logging location in Amazon S3 to specify.
         * </p>
         * <note>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket
         * to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options
         * in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems
         * Manager handles these options for the supported maintenance window task types, see
         * <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note>
         * 
         * @param loggingInfo
         *        The new logging location in Amazon S3 to specify.</p> <note>
         *        <p>
         *        <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3)
         *        bucket to contain logs, instead use the <code>OutputS3BucketName</code> and
         *        <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For
         *        information about how Amazon Web Services Systems Manager handles these options for the supported
         *        maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * <p>
         * The new logging location in Amazon S3 to specify.
         * </p>
         * <note>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket
         * to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options
         * in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems
         * Manager handles these options for the supported maintenance window task types, see
         * <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link LoggingInfo.Builder} avoiding the
         * need to create one manually via {@link LoggingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         * <p>
         * The new task name to specify.
         * </p>
         * 
         * @param name
         *        The new task name to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new task description to specify.
         * </p>
         * 
         * @param description
         *        The new task description to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are also
         * required for this API request. Optional fields that aren't specified are set to null.
         * </p>
         * 
         * @param replace
         *        If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation
         *        are also required for this API request. Optional fields that aren't specified are set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);

        /**
         * <p>
         * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is
         * reached.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_TASK</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are
         * already running continue, but no new task invocations are started.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation
         * that attempts to cancel the command associated with the task. However, there is no guarantee that the command
         * will be terminated and the underlying process stopped.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The status for tasks that are not completed is <code>TIMED_OUT</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cutoffBehavior
         *        Indicates whether tasks should continue to run after the cutoff time specified in the maintenance
         *        windows is reached. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The
         *        default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_TASK</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations
         *        that are already running continue, but no new task invocations are started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a>
         *        operation that attempts to cancel the command associated with the task. However, there is no guarantee
         *        that the command will be terminated and the underlying process stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The status for tasks that are not completed is <code>TIMED_OUT</code>.
         *        </p>
         *        </li>
         * @see MaintenanceWindowTaskCutoffBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskCutoffBehavior
         */
        Builder cutoffBehavior(String cutoffBehavior);

        /**
         * <p>
         * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is
         * reached.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_TASK</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are
         * already running continue, but no new task invocations are started.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation
         * that attempts to cancel the command associated with the task. However, there is no guarantee that the command
         * will be terminated and the underlying process stopped.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The status for tasks that are not completed is <code>TIMED_OUT</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cutoffBehavior
         *        Indicates whether tasks should continue to run after the cutoff time specified in the maintenance
         *        windows is reached. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The
         *        default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_TASK</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations
         *        that are already running continue, but no new task invocations are started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a>
         *        operation that attempts to cancel the command associated with the task. However, there is no guarantee
         *        that the command will be terminated and the underlying process stopped.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The status for tasks that are not completed is <code>TIMED_OUT</code>.
         *        </p>
         *        </li>
         * @see MaintenanceWindowTaskCutoffBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskCutoffBehavior
         */
        Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior cutoffBehavior);

        /**
         * <p>
         * The CloudWatch alarm you want to apply to your maintenance window task.
         * </p>
         * 
         * @param alarmConfiguration
         *        The CloudWatch alarm you want to apply to your maintenance window task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * The CloudWatch alarm you want to apply to your maintenance window task.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String taskArn;

        private String serviceRoleArn;

        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters = DefaultSdkAutoConstructMap
                .getInstance();

        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

        private Integer priority;

        private String maxConcurrency;

        private String maxErrors;

        private LoggingInfo loggingInfo;

        private String name;

        private String description;

        private Boolean replace;

        private String cutoffBehavior;

        private AlarmConfiguration alarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTaskRequest model) {
            super(model);
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
            targets(model.targets);
            taskArn(model.taskArn);
            serviceRoleArn(model.serviceRoleArn);
            taskParameters(model.taskParameters);
            taskInvocationParameters(model.taskInvocationParameters);
            priority(model.priority);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            loggingInfo(model.loggingInfo);
            name(model.name);
            description(model.description);
            replace(model.replace);
            cutoffBehavior(model.cutoffBehavior);
            alarmConfiguration(model.alarmConfiguration);
        }

        public final String getWindowId() {
            return windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> result = MaintenanceWindowTaskParametersCopier
                    .copyToBuilder(this.taskParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return taskInvocationParameters != null ? taskInvocationParameters.toBuilder() : null;
        }

        public final void setTaskInvocationParameters(
                MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getReplace() {
            return replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final String getCutoffBehavior() {
            return cutoffBehavior;
        }

        public final void setCutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
        }

        @Override
        public final Builder cutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
            return this;
        }

        @Override
        public final Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior cutoffBehavior) {
            this.cutoffBehavior(cutoffBehavior == null ? null : cutoffBehavior.toString());
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowTaskRequest build() {
            return new UpdateMaintenanceWindowTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
