/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encloses a receipt handle and an entry id for each message in <code> <a>ChangeMessageVisibilityBatch</a>.</code>
 * </p>
 * <important>
 * <p>
 * All of the following list parameters must be prefixed with <code>ChangeMessageVisibilityBatchRequestEntry.n</code>,
 * where <code>n</code> is an integer value starting with <code>1</code>. For example, a parameter list for this action
 * might look like this:
 * </p>
 * </important>
 * <p>
 * <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2</code>
 * </p>
 * <p>
 * <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=your_receipt_handle</code>
 * </p>
 * <p>
 * <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeMessageVisibilityBatchRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeMessageVisibilityBatchRequestEntry.Builder, ChangeMessageVisibilityBatchRequestEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ChangeMessageVisibilityBatchRequestEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RECEIPT_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceiptHandle").getter(getter(ChangeMessageVisibilityBatchRequestEntry::receiptHandle))
            .setter(setter(Builder::receiptHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptHandle").build()).build();

    private static final SdkField<Integer> VISIBILITY_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VisibilityTimeout").getter(getter(ChangeMessageVisibilityBatchRequestEntry::visibilityTimeout))
            .setter(setter(Builder::visibilityTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RECEIPT_HANDLE_FIELD, VISIBILITY_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String receiptHandle;

    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    /**
     * <p>
     * An identifier for this particular receipt handle used to communicate the result.
     * </p>
     * <note>
     * <p>
     * The <code>Id</code>s of a batch request need to be unique within a request.
     * </p>
     * <p>
     * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters,
     * hyphens(-), and underscores (_).
     * </p>
     * </note>
     * 
     * @return An identifier for this particular receipt handle used to communicate the result.</p> <note>
     *         <p>
     *         The <code>Id</code>s of a batch request need to be unique within a request.
     *         </p>
     *         <p>
     *         This identifier can have up to 80 characters. The following characters are accepted: alphanumeric
     *         characters, hyphens(-), and underscores (_).
     *         </p>
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A receipt handle.
     * </p>
     * 
     * @return A receipt handle.
     */
    public final String receiptHandle() {
        return receiptHandle;
    }

    /**
     * <p>
     * The new value (in seconds) for the message's visibility timeout.
     * </p>
     * 
     * @return The new value (in seconds) for the message's visibility timeout.
     */
    public final Integer visibilityTimeout() {
        return visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequestEntry)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequestEntry other = (ChangeMessageVisibilityBatchRequestEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(receiptHandle(), other.receiptHandle())
                && Objects.equals(visibilityTimeout(), other.visibilityTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeMessageVisibilityBatchRequestEntry").add("Id", id()).add("ReceiptHandle", receiptHandle())
                .add("VisibilityTimeout", visibilityTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ReceiptHandle":
            return Optional.ofNullable(clazz.cast(receiptHandle()));
        case "VisibilityTimeout":
            return Optional.ofNullable(clazz.cast(visibilityTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeMessageVisibilityBatchRequestEntry, T> g) {
        return obj -> g.apply((ChangeMessageVisibilityBatchRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeMessageVisibilityBatchRequestEntry> {
        /**
         * <p>
         * An identifier for this particular receipt handle used to communicate the result.
         * </p>
         * <note>
         * <p>
         * The <code>Id</code>s of a batch request need to be unique within a request.
         * </p>
         * <p>
         * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters,
         * hyphens(-), and underscores (_).
         * </p>
         * </note>
         * 
         * @param id
         *        An identifier for this particular receipt handle used to communicate the result.</p> <note>
         *        <p>
         *        The <code>Id</code>s of a batch request need to be unique within a request.
         *        </p>
         *        <p>
         *        This identifier can have up to 80 characters. The following characters are accepted: alphanumeric
         *        characters, hyphens(-), and underscores (_).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A receipt handle.
         * </p>
         * 
         * @param receiptHandle
         *        A receipt handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);

        /**
         * <p>
         * The new value (in seconds) for the message's visibility timeout.
         * </p>
         * 
         * @param visibilityTimeout
         *        The new value (in seconds) for the message's visibility timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityTimeout(Integer visibilityTimeout);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String receiptHandle;

        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchRequestEntry model) {
            id(model.id);
            receiptHandle(model.receiptHandle);
            visibilityTimeout(model.visibilityTimeout);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public ChangeMessageVisibilityBatchRequestEntry build() {
            return new ChangeMessageVisibilityBatchRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
