/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BounceType {
    DOES_NOT_EXIST("DoesNotExist"),
    MESSAGE_TOO_LARGE("MessageTooLarge"),
    EXCEEDED_QUOTA("ExceededQuota"),
    CONTENT_REJECTED("ContentRejected"),
    UNDEFINED("Undefined"),
    TEMPORARY_FAILURE("TemporaryFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BounceType> VALUE_MAP;
    private final String value;

    private BounceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BounceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BounceType> knownValues() {
        EnumSet<BounceType> knownValues = EnumSet.allOf(BounceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BounceType.class, BounceType::toString);
    }
}

