/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomLogSourceResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, CreateCustomLogSourceResponse> {
    private static final SdkField<String> CUSTOM_DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDataLocation").getter(CreateCustomLogSourceResponse.getter(CreateCustomLogSourceResponse::customDataLocation)).setter(CreateCustomLogSourceResponse.setter(Builder::customDataLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataLocation").build()}).build();
    private static final SdkField<String> GLUE_CRAWLER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glueCrawlerName").getter(CreateCustomLogSourceResponse.getter(CreateCustomLogSourceResponse::glueCrawlerName)).setter(CreateCustomLogSourceResponse.setter(Builder::glueCrawlerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueCrawlerName").build()}).build();
    private static final SdkField<String> GLUE_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glueDatabaseName").getter(CreateCustomLogSourceResponse.getter(CreateCustomLogSourceResponse::glueDatabaseName)).setter(CreateCustomLogSourceResponse.setter(Builder::glueDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueDatabaseName").build()}).build();
    private static final SdkField<String> GLUE_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glueTableName").getter(CreateCustomLogSourceResponse.getter(CreateCustomLogSourceResponse::glueTableName)).setter(CreateCustomLogSourceResponse.setter(Builder::glueTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueTableName").build()}).build();
    private static final SdkField<String> LOG_PROVIDER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logProviderAccessRoleArn").getter(CreateCustomLogSourceResponse.getter(CreateCustomLogSourceResponse::logProviderAccessRoleArn)).setter(CreateCustomLogSourceResponse.setter(Builder::logProviderAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logProviderAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_LOCATION_FIELD, GLUE_CRAWLER_NAME_FIELD, GLUE_DATABASE_NAME_FIELD, GLUE_TABLE_NAME_FIELD, LOG_PROVIDER_ACCESS_ROLE_ARN_FIELD));
    private final String customDataLocation;
    private final String glueCrawlerName;
    private final String glueDatabaseName;
    private final String glueTableName;
    private final String logProviderAccessRoleArn;

    private CreateCustomLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.customDataLocation = builder.customDataLocation;
        this.glueCrawlerName = builder.glueCrawlerName;
        this.glueDatabaseName = builder.glueDatabaseName;
        this.glueTableName = builder.glueTableName;
        this.logProviderAccessRoleArn = builder.logProviderAccessRoleArn;
    }

    public final String customDataLocation() {
        return this.customDataLocation;
    }

    public final String glueCrawlerName() {
        return this.glueCrawlerName;
    }

    public final String glueDatabaseName() {
        return this.glueDatabaseName;
    }

    public final String glueTableName() {
        return this.glueTableName;
    }

    public final String logProviderAccessRoleArn() {
        return this.logProviderAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueCrawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logProviderAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceResponse)) {
            return false;
        }
        CreateCustomLogSourceResponse other = (CreateCustomLogSourceResponse)((Object)obj);
        return Objects.equals(this.customDataLocation(), other.customDataLocation()) && Objects.equals(this.glueCrawlerName(), other.glueCrawlerName()) && Objects.equals(this.glueDatabaseName(), other.glueDatabaseName()) && Objects.equals(this.glueTableName(), other.glueTableName()) && Objects.equals(this.logProviderAccessRoleArn(), other.logProviderAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomLogSourceResponse").add("CustomDataLocation", (Object)this.customDataLocation()).add("GlueCrawlerName", (Object)this.glueCrawlerName()).add("GlueDatabaseName", (Object)this.glueDatabaseName()).add("GlueTableName", (Object)this.glueTableName()).add("LogProviderAccessRoleArn", (Object)this.logProviderAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customDataLocation": {
                return Optional.ofNullable(clazz.cast(this.customDataLocation()));
            }
            case "glueCrawlerName": {
                return Optional.ofNullable(clazz.cast(this.glueCrawlerName()));
            }
            case "glueDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.glueDatabaseName()));
            }
            case "glueTableName": {
                return Optional.ofNullable(clazz.cast(this.glueTableName()));
            }
            case "logProviderAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.logProviderAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceResponse, T> g) {
        return obj -> g.apply((CreateCustomLogSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private String customDataLocation;
        private String glueCrawlerName;
        private String glueDatabaseName;
        private String glueTableName;
        private String logProviderAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceResponse model) {
            super(model);
            this.customDataLocation(model.customDataLocation);
            this.glueCrawlerName(model.glueCrawlerName);
            this.glueDatabaseName(model.glueDatabaseName);
            this.glueTableName(model.glueTableName);
            this.logProviderAccessRoleArn(model.logProviderAccessRoleArn);
        }

        public final String getCustomDataLocation() {
            return this.customDataLocation;
        }

        public final void setCustomDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
        }

        @Override
        public final Builder customDataLocation(String customDataLocation) {
            this.customDataLocation = customDataLocation;
            return this;
        }

        public final String getGlueCrawlerName() {
            return this.glueCrawlerName;
        }

        public final void setGlueCrawlerName(String glueCrawlerName) {
            this.glueCrawlerName = glueCrawlerName;
        }

        @Override
        public final Builder glueCrawlerName(String glueCrawlerName) {
            this.glueCrawlerName = glueCrawlerName;
            return this;
        }

        public final String getGlueDatabaseName() {
            return this.glueDatabaseName;
        }

        public final void setGlueDatabaseName(String glueDatabaseName) {
            this.glueDatabaseName = glueDatabaseName;
        }

        @Override
        public final Builder glueDatabaseName(String glueDatabaseName) {
            this.glueDatabaseName = glueDatabaseName;
            return this;
        }

        public final String getGlueTableName() {
            return this.glueTableName;
        }

        public final void setGlueTableName(String glueTableName) {
            this.glueTableName = glueTableName;
        }

        @Override
        public final Builder glueTableName(String glueTableName) {
            this.glueTableName = glueTableName;
            return this;
        }

        public final String getLogProviderAccessRoleArn() {
            return this.logProviderAccessRoleArn;
        }

        public final void setLogProviderAccessRoleArn(String logProviderAccessRoleArn) {
            this.logProviderAccessRoleArn = logProviderAccessRoleArn;
        }

        @Override
        public final Builder logProviderAccessRoleArn(String logProviderAccessRoleArn) {
            this.logProviderAccessRoleArn = logProviderAccessRoleArn;
            return this;
        }

        @Override
        public CreateCustomLogSourceResponse build() {
            return new CreateCustomLogSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomLogSourceResponse> {
        public Builder customDataLocation(String var1);

        public Builder glueCrawlerName(String var1);

        public Builder glueDatabaseName(String var1);

        public Builder glueTableName(String var1);

        public Builder logProviderAccessRoleArn(String var1);
    }
}

