/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines the rotation configuration for the secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotationRulesType implements SdkPojo, Serializable,
        ToCopyableBuilder<RotationRulesType.Builder, RotationRulesType> {
    private static final SdkField<Long> AUTOMATICALLY_AFTER_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(RotationRulesType::automaticallyAfterDays)).setter(setter(Builder::automaticallyAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticallyAfterDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTOMATICALLY_AFTER_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long automaticallyAfterDays;

    private RotationRulesType(BuilderImpl builder) {
        this.automaticallyAfterDays = builder.automaticallyAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days between automatic scheduled rotations of the secret.
     * </p>
     * <p>
     * Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules the date
     * by adding the rotation interval (number of days) to the actual date of the last rotation. The service chooses the
     * hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but weighted towards
     * the top of the hour and influenced by a variety of factors that help distribute load.
     * </p>
     * 
     * @return Specifies the number of days between automatic scheduled rotations of the secret.</p>
     *         <p>
     *         Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules
     *         the date by adding the rotation interval (number of days) to the actual date of the last rotation. The
     *         service chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat
     *         randomly, but weighted towards the top of the hour and influenced by a variety of factors that help
     *         distribute load.
     */
    public Long automaticallyAfterDays() {
        return automaticallyAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticallyAfterDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationRulesType)) {
            return false;
        }
        RotationRulesType other = (RotationRulesType) obj;
        return Objects.equals(automaticallyAfterDays(), other.automaticallyAfterDays());
    }

    @Override
    public String toString() {
        return ToString.builder("RotationRulesType").add("AutomaticallyAfterDays", automaticallyAfterDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticallyAfterDays":
            return Optional.ofNullable(clazz.cast(automaticallyAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotationRulesType, T> g) {
        return obj -> g.apply((RotationRulesType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RotationRulesType> {
        /**
         * <p>
         * Specifies the number of days between automatic scheduled rotations of the secret.
         * </p>
         * <p>
         * Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules the
         * date by adding the rotation interval (number of days) to the actual date of the last rotation. The service
         * chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but
         * weighted towards the top of the hour and influenced by a variety of factors that help distribute load.
         * </p>
         * 
         * @param automaticallyAfterDays
         *        Specifies the number of days between automatic scheduled rotations of the secret.</p>
         *        <p>
         *        Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager
         *        schedules the date by adding the rotation interval (number of days) to the actual date of the last
         *        rotation. The service chooses the hour within that 24-hour date window randomly. The minute is also
         *        chosen somewhat randomly, but weighted towards the top of the hour and influenced by a variety of
         *        factors that help distribute load.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticallyAfterDays(Long automaticallyAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private Long automaticallyAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationRulesType model) {
            automaticallyAfterDays(model.automaticallyAfterDays);
        }

        public final Long getAutomaticallyAfterDays() {
            return automaticallyAfterDays;
        }

        @Override
        public final Builder automaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
            return this;
        }

        public final void setAutomaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
        }

        @Override
        public RotationRulesType build() {
            return new RotationRulesType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
