/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType;

public class ListSupportedResourceTypesIterable
implements SdkIterable<ListSupportedResourceTypesResponse> {
    private final ResourceExplorer2Client client;
    private final ListSupportedResourceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSupportedResourceTypesIterable(ResourceExplorer2Client client, ListSupportedResourceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSupportedResourceTypesResponseFetcher();
    }

    public Iterator<ListSupportedResourceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SupportedResourceType> resourceTypes() {
        Function<ListSupportedResourceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTypes() != null) {
                return response.resourceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSupportedResourceTypesResponseFetcher
    implements SyncPageFetcher<ListSupportedResourceTypesResponse> {
        private ListSupportedResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSupportedResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSupportedResourceTypesResponse nextPage(ListSupportedResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSupportedResourceTypesIterable.this.client.listSupportedResourceTypes(ListSupportedResourceTypesIterable.this.firstRequest);
            }
            return ListSupportedResourceTypesIterable.this.client.listSupportedResourceTypes((ListSupportedResourceTypesRequest)((Object)ListSupportedResourceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

