/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.TopicIR;
import software.amazon.awssdk.services.quicksight.model.TopicVisualsCopier;
import software.amazon.awssdk.services.quicksight.model.VisualRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(TopicVisual.getter(TopicVisual::visualId)).setter(TopicVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(TopicVisual.getter(TopicVisual::roleAsString)).setter(TopicVisual.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<TopicIR> IR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ir").getter(TopicVisual.getter(TopicVisual::ir)).setter(TopicVisual.setter(Builder::ir)).constructor(TopicIR::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ir").build()}).build();
    private static final SdkField<List<TopicVisual>> SUPPORTING_VISUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportingVisuals").getter(TopicVisual.getter(TopicVisual::supportingVisuals)).setter(TopicVisual.setter(Builder::supportingVisuals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportingVisuals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, ROLE_FIELD, IR_FIELD, SUPPORTING_VISUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicVisual.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final String role;
    private final TopicIR ir;
    private final List<TopicVisual> supportingVisuals;

    private TopicVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.role = builder.role;
        this.ir = builder.ir;
        this.supportingVisuals = builder.supportingVisuals;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final VisualRole role() {
        return VisualRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final TopicIR ir() {
        return this.ir;
    }

    public final boolean hasSupportingVisuals() {
        return this.supportingVisuals != null && !(this.supportingVisuals instanceof SdkAutoConstructList);
    }

    public final List<TopicVisual> supportingVisuals() {
        return this.supportingVisuals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ir());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportingVisuals() ? this.supportingVisuals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicVisual)) {
            return false;
        }
        TopicVisual other = (TopicVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.ir(), other.ir()) && this.hasSupportingVisuals() == other.hasSupportingVisuals() && Objects.equals(this.supportingVisuals(), other.supportingVisuals());
    }

    public final String toString() {
        return ToString.builder((String)"TopicVisual").add("VisualId", (Object)this.visualId()).add("Role", (Object)this.roleAsString()).add("Ir", (Object)this.ir()).add("SupportingVisuals", this.hasSupportingVisuals() ? this.supportingVisuals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Ir": {
                return Optional.ofNullable(clazz.cast(this.ir()));
            }
            case "SupportingVisuals": {
                return Optional.ofNullable(clazz.cast(this.supportingVisuals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Ir", IR_FIELD);
        map.put("SupportingVisuals", SUPPORTING_VISUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicVisual, T> g) {
        return obj -> g.apply((TopicVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private String role;
        private TopicIR ir;
        private List<TopicVisual> supportingVisuals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicVisual model) {
            this.visualId(model.visualId);
            this.role(model.role);
            this.ir(model.ir);
            this.supportingVisuals(model.supportingVisuals);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(VisualRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final TopicIR.Builder getIr() {
            return this.ir != null ? this.ir.toBuilder() : null;
        }

        public final void setIr(TopicIR.BuilderImpl ir) {
            this.ir = ir != null ? ir.build() : null;
        }

        @Override
        public final Builder ir(TopicIR ir) {
            this.ir = ir;
            return this;
        }

        public final List<Builder> getSupportingVisuals() {
            List<Builder> result = TopicVisualsCopier.copyToBuilder(this.supportingVisuals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingVisuals(Collection<BuilderImpl> supportingVisuals) {
            this.supportingVisuals = TopicVisualsCopier.copyFromBuilder(supportingVisuals);
        }

        @Override
        public final Builder supportingVisuals(Collection<TopicVisual> supportingVisuals) {
            this.supportingVisuals = TopicVisualsCopier.copy(supportingVisuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingVisuals(TopicVisual ... supportingVisuals) {
            this.supportingVisuals(Arrays.asList(supportingVisuals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingVisuals(Consumer<Builder> ... supportingVisuals) {
            this.supportingVisuals(Stream.of(supportingVisuals).map(c -> (TopicVisual)((Builder)TopicVisual.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TopicVisual build() {
            return new TopicVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicVisual> {
        public Builder visualId(String var1);

        public Builder role(String var1);

        public Builder role(VisualRole var1);

        public Builder ir(TopicIR var1);

        default public Builder ir(Consumer<TopicIR.Builder> ir) {
            return this.ir((TopicIR)((TopicIR.Builder)TopicIR.builder().applyMutation(ir)).build());
        }

        public Builder supportingVisuals(Collection<TopicVisual> var1);

        public Builder supportingVisuals(TopicVisual ... var1);

        public Builder supportingVisuals(Consumer<Builder> ... var1);
    }
}

