/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CrossDatasetTypes;
import software.amazon.awssdk.services.quicksight.model.Filter;
import software.amazon.awssdk.services.quicksight.model.FilterListCopier;
import software.amazon.awssdk.services.quicksight.model.FilterScopeConfiguration;
import software.amazon.awssdk.services.quicksight.model.WidgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterGroup> {
    private static final SdkField<String> FILTER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterGroupId").getter(FilterGroup.getter(FilterGroup::filterGroupId)).setter(FilterGroup.setter(Builder::filterGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGroupId").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(FilterGroup.getter(FilterGroup::filters)).setter(FilterGroup.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FilterScopeConfiguration> SCOPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScopeConfiguration").getter(FilterGroup.getter(FilterGroup::scopeConfiguration)).setter(FilterGroup.setter(Builder::scopeConfiguration)).constructor(FilterScopeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FilterGroup.getter(FilterGroup::statusAsString)).setter(FilterGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CROSS_DATASET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrossDataset").getter(FilterGroup.getter(FilterGroup::crossDatasetAsString)).setter(FilterGroup.setter(Builder::crossDataset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossDataset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_GROUP_ID_FIELD, FILTERS_FIELD, SCOPE_CONFIGURATION_FIELD, STATUS_FIELD, CROSS_DATASET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterGroupId;
    private final List<Filter> filters;
    private final FilterScopeConfiguration scopeConfiguration;
    private final String status;
    private final String crossDataset;

    private FilterGroup(BuilderImpl builder) {
        this.filterGroupId = builder.filterGroupId;
        this.filters = builder.filters;
        this.scopeConfiguration = builder.scopeConfiguration;
        this.status = builder.status;
        this.crossDataset = builder.crossDataset;
    }

    public final String filterGroupId() {
        return this.filterGroupId;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final FilterScopeConfiguration scopeConfiguration() {
        return this.scopeConfiguration;
    }

    public final WidgetStatus status() {
        return WidgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CrossDatasetTypes crossDataset() {
        return CrossDatasetTypes.fromValue(this.crossDataset);
    }

    public final String crossDatasetAsString() {
        return this.crossDataset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossDatasetAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterGroup)) {
            return false;
        }
        FilterGroup other = (FilterGroup)obj;
        return Objects.equals(this.filterGroupId(), other.filterGroupId()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.scopeConfiguration(), other.scopeConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.crossDatasetAsString(), other.crossDatasetAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FilterGroup").add("FilterGroupId", (Object)this.filterGroupId()).add("Filters", this.hasFilters() ? this.filters() : null).add("ScopeConfiguration", (Object)this.scopeConfiguration()).add("Status", (Object)this.statusAsString()).add("CrossDataset", (Object)this.crossDatasetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterGroupId": {
                return Optional.ofNullable(clazz.cast(this.filterGroupId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ScopeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scopeConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CrossDataset": {
                return Optional.ofNullable(clazz.cast(this.crossDatasetAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilterGroupId", FILTER_GROUP_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("ScopeConfiguration", SCOPE_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CrossDataset", CROSS_DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterGroup, T> g) {
        return obj -> g.apply((FilterGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterGroupId;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private FilterScopeConfiguration scopeConfiguration;
        private String status;
        private String crossDataset;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterGroup model) {
            this.filterGroupId(model.filterGroupId);
            this.filters(model.filters);
            this.scopeConfiguration(model.scopeConfiguration);
            this.status(model.status);
            this.crossDataset(model.crossDataset);
        }

        public final String getFilterGroupId() {
            return this.filterGroupId;
        }

        public final void setFilterGroupId(String filterGroupId) {
            this.filterGroupId = filterGroupId;
        }

        @Override
        public final Builder filterGroupId(String filterGroupId) {
            this.filterGroupId = filterGroupId;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterScopeConfiguration.Builder getScopeConfiguration() {
            return this.scopeConfiguration != null ? this.scopeConfiguration.toBuilder() : null;
        }

        public final void setScopeConfiguration(FilterScopeConfiguration.BuilderImpl scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration != null ? scopeConfiguration.build() : null;
        }

        @Override
        public final Builder scopeConfiguration(FilterScopeConfiguration scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCrossDataset() {
            return this.crossDataset;
        }

        public final void setCrossDataset(String crossDataset) {
            this.crossDataset = crossDataset;
        }

        @Override
        public final Builder crossDataset(String crossDataset) {
            this.crossDataset = crossDataset;
            return this;
        }

        @Override
        public final Builder crossDataset(CrossDatasetTypes crossDataset) {
            this.crossDataset(crossDataset == null ? null : crossDataset.toString());
            return this;
        }

        public FilterGroup build() {
            return new FilterGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterGroup> {
        public Builder filterGroupId(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder scopeConfiguration(FilterScopeConfiguration var1);

        default public Builder scopeConfiguration(Consumer<FilterScopeConfiguration.Builder> scopeConfiguration) {
            return this.scopeConfiguration((FilterScopeConfiguration)((FilterScopeConfiguration.Builder)FilterScopeConfiguration.builder().applyMutation(scopeConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(WidgetStatus var1);

        public Builder crossDataset(String var1);

        public Builder crossDataset(CrossDatasetTypes var1);
    }
}

