/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AuthenticationType;
import software.amazon.awssdk.services.quicksight.model.OAuthParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(SnowflakeParameters.getter(SnowflakeParameters::host)).setter(SnowflakeParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(SnowflakeParameters.getter(SnowflakeParameters::database)).setter(SnowflakeParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Warehouse").getter(SnowflakeParameters.getter(SnowflakeParameters::warehouse)).setter(SnowflakeParameters.setter(Builder::warehouse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warehouse").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(SnowflakeParameters.getter(SnowflakeParameters::authenticationTypeAsString)).setter(SnowflakeParameters.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<String> DATABASE_ACCESS_CONTROL_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseAccessControlRole").getter(SnowflakeParameters.getter(SnowflakeParameters::databaseAccessControlRole)).setter(SnowflakeParameters.setter(Builder::databaseAccessControlRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseAccessControlRole").build()}).build();
    private static final SdkField<OAuthParameters> O_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuthParameters").getter(SnowflakeParameters.getter(SnowflakeParameters::oAuthParameters)).setter(SnowflakeParameters.setter(Builder::oAuthParameters)).constructor(OAuthParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, DATABASE_FIELD, WAREHOUSE_FIELD, AUTHENTICATION_TYPE_FIELD, DATABASE_ACCESS_CONTROL_ROLE_FIELD, O_AUTH_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnowflakeParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String host;
    private final String database;
    private final String warehouse;
    private final String authenticationType;
    private final String databaseAccessControlRole;
    private final OAuthParameters oAuthParameters;

    private SnowflakeParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.database = builder.database;
        this.warehouse = builder.warehouse;
        this.authenticationType = builder.authenticationType;
        this.databaseAccessControlRole = builder.databaseAccessControlRole;
        this.oAuthParameters = builder.oAuthParameters;
    }

    public final String host() {
        return this.host;
    }

    public final String database() {
        return this.database;
    }

    public final String warehouse() {
        return this.warehouse;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final String databaseAccessControlRole() {
        return this.databaseAccessControlRole;
    }

    public final OAuthParameters oAuthParameters() {
        return this.oAuthParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouse());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseAccessControlRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeParameters)) {
            return false;
        }
        SnowflakeParameters other = (SnowflakeParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.warehouse(), other.warehouse()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.databaseAccessControlRole(), other.databaseAccessControlRole()) && Objects.equals(this.oAuthParameters(), other.oAuthParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeParameters").add("Host", (Object)this.host()).add("Database", (Object)this.database()).add("Warehouse", (Object)this.warehouse()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("DatabaseAccessControlRole", (Object)this.databaseAccessControlRole()).add("OAuthParameters", (Object)this.oAuthParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Warehouse": {
                return Optional.ofNullable(clazz.cast(this.warehouse()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "DatabaseAccessControlRole": {
                return Optional.ofNullable(clazz.cast(this.databaseAccessControlRole()));
            }
            case "OAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.oAuthParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Host", HOST_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Warehouse", WAREHOUSE_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("DatabaseAccessControlRole", DATABASE_ACCESS_CONTROL_ROLE_FIELD);
        map.put("OAuthParameters", O_AUTH_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeParameters, T> g) {
        return obj -> g.apply((SnowflakeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private String database;
        private String warehouse;
        private String authenticationType;
        private String databaseAccessControlRole;
        private OAuthParameters oAuthParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeParameters model) {
            this.host(model.host);
            this.database(model.database);
            this.warehouse(model.warehouse);
            this.authenticationType(model.authenticationType);
            this.databaseAccessControlRole(model.databaseAccessControlRole);
            this.oAuthParameters(model.oAuthParameters);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getWarehouse() {
            return this.warehouse;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Override
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getDatabaseAccessControlRole() {
            return this.databaseAccessControlRole;
        }

        public final void setDatabaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
        }

        @Override
        public final Builder databaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
            return this;
        }

        public final OAuthParameters.Builder getOAuthParameters() {
            return this.oAuthParameters != null ? this.oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(OAuthParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(OAuthParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        public SnowflakeParameters build() {
            return new SnowflakeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeParameters> {
        public Builder host(String var1);

        public Builder database(String var1);

        public Builder warehouse(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder databaseAccessControlRole(String var1);

        public Builder oAuthParameters(OAuthParameters var1);

        default public Builder oAuthParameters(Consumer<OAuthParameters.Builder> oAuthParameters) {
            return this.oAuthParameters((OAuthParameters)((OAuthParameters.Builder)OAuthParameters.builder().applyMutation(oAuthParameters)).build());
        }
    }
}

