/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.services.quicksight.model.VisibleRangeOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScrollBarOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScrollBarOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(ScrollBarOptions.getter(ScrollBarOptions::visibilityAsString)).setter(ScrollBarOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<VisibleRangeOptions> VISIBLE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibleRange").getter(ScrollBarOptions.getter(ScrollBarOptions::visibleRange)).setter(ScrollBarOptions.setter(Builder::visibleRange)).constructor(VisibleRangeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, VISIBLE_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScrollBarOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final VisibleRangeOptions visibleRange;

    private ScrollBarOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.visibleRange = builder.visibleRange;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final VisibleRangeOptions visibleRange() {
        return this.visibleRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScrollBarOptions)) {
            return false;
        }
        ScrollBarOptions other = (ScrollBarOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.visibleRange(), other.visibleRange());
    }

    public final String toString() {
        return ToString.builder((String)"ScrollBarOptions").add("Visibility", (Object)this.visibilityAsString()).add("VisibleRange", (Object)this.visibleRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "VisibleRange": {
                return Optional.ofNullable(clazz.cast(this.visibleRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("VisibleRange", VISIBLE_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScrollBarOptions, T> g) {
        return obj -> g.apply((ScrollBarOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private VisibleRangeOptions visibleRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ScrollBarOptions model) {
            this.visibility(model.visibility);
            this.visibleRange(model.visibleRange);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final VisibleRangeOptions.Builder getVisibleRange() {
            return this.visibleRange != null ? this.visibleRange.toBuilder() : null;
        }

        public final void setVisibleRange(VisibleRangeOptions.BuilderImpl visibleRange) {
            this.visibleRange = visibleRange != null ? visibleRange.build() : null;
        }

        @Override
        public final Builder visibleRange(VisibleRangeOptions visibleRange) {
            this.visibleRange = visibleRange;
            return this;
        }

        public ScrollBarOptions build() {
            return new ScrollBarOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScrollBarOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder visibleRange(VisibleRangeOptions var1);

        default public Builder visibleRange(Consumer<VisibleRangeOptions.Builder> visibleRange) {
            return this.visibleRange((VisibleRangeOptions)((VisibleRangeOptions.Builder)VisibleRangeOptions.builder().applyMutation(visibleRange)).build());
        }
    }
}

