/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryFilter;
import software.amazon.awssdk.services.quicksight.model.NestedFilter;
import software.amazon.awssdk.services.quicksight.model.NumericEqualityFilter;
import software.amazon.awssdk.services.quicksight.model.NumericRangeFilter;
import software.amazon.awssdk.services.quicksight.model.RelativeDatesFilter;
import software.amazon.awssdk.services.quicksight.model.TimeEqualityFilter;
import software.amazon.awssdk.services.quicksight.model.TimeRangeFilter;
import software.amazon.awssdk.services.quicksight.model.TopBottomFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<CategoryFilter> CATEGORY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryFilter").getter(Filter.getter(Filter::categoryFilter)).setter(Filter.setter(Builder::categoryFilter)).constructor(CategoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()}).build();
    private static final SdkField<NumericRangeFilter> NUMERIC_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericRangeFilter").getter(Filter.getter(Filter::numericRangeFilter)).setter(Filter.setter(Builder::numericRangeFilter)).constructor(NumericRangeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericRangeFilter").build()}).build();
    private static final SdkField<NumericEqualityFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericEqualityFilter").getter(Filter.getter(Filter::numericEqualityFilter)).setter(Filter.setter(Builder::numericEqualityFilter)).constructor(NumericEqualityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build()}).build();
    private static final SdkField<TimeEqualityFilter> TIME_EQUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeEqualityFilter").getter(Filter.getter(Filter::timeEqualityFilter)).setter(Filter.setter(Builder::timeEqualityFilter)).constructor(TimeEqualityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeEqualityFilter").build()}).build();
    private static final SdkField<TimeRangeFilter> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeFilter").getter(Filter.getter(Filter::timeRangeFilter)).setter(Filter.setter(Builder::timeRangeFilter)).constructor(TimeRangeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()}).build();
    private static final SdkField<RelativeDatesFilter> RELATIVE_DATES_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelativeDatesFilter").getter(Filter.getter(Filter::relativeDatesFilter)).setter(Filter.setter(Builder::relativeDatesFilter)).constructor(RelativeDatesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDatesFilter").build()}).build();
    private static final SdkField<TopBottomFilter> TOP_BOTTOM_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopBottomFilter").getter(Filter.getter(Filter::topBottomFilter)).setter(Filter.setter(Builder::topBottomFilter)).constructor(TopBottomFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomFilter").build()}).build();
    private static final SdkField<NestedFilter> NESTED_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NestedFilter").getter(Filter.getter(Filter::nestedFilter)).setter(Filter.setter(Builder::nestedFilter)).constructor(NestedFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FILTER_FIELD, NUMERIC_RANGE_FILTER_FIELD, NUMERIC_EQUALITY_FILTER_FIELD, TIME_EQUALITY_FILTER_FIELD, TIME_RANGE_FILTER_FIELD, RELATIVE_DATES_FILTER_FIELD, TOP_BOTTOM_FILTER_FIELD, NESTED_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Filter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CategoryFilter categoryFilter;
    private final NumericRangeFilter numericRangeFilter;
    private final NumericEqualityFilter numericEqualityFilter;
    private final TimeEqualityFilter timeEqualityFilter;
    private final TimeRangeFilter timeRangeFilter;
    private final RelativeDatesFilter relativeDatesFilter;
    private final TopBottomFilter topBottomFilter;
    private final NestedFilter nestedFilter;

    private Filter(BuilderImpl builder) {
        this.categoryFilter = builder.categoryFilter;
        this.numericRangeFilter = builder.numericRangeFilter;
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.timeEqualityFilter = builder.timeEqualityFilter;
        this.timeRangeFilter = builder.timeRangeFilter;
        this.relativeDatesFilter = builder.relativeDatesFilter;
        this.topBottomFilter = builder.topBottomFilter;
        this.nestedFilter = builder.nestedFilter;
    }

    public final CategoryFilter categoryFilter() {
        return this.categoryFilter;
    }

    public final NumericRangeFilter numericRangeFilter() {
        return this.numericRangeFilter;
    }

    public final NumericEqualityFilter numericEqualityFilter() {
        return this.numericEqualityFilter;
    }

    public final TimeEqualityFilter timeEqualityFilter() {
        return this.timeEqualityFilter;
    }

    public final TimeRangeFilter timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public final RelativeDatesFilter relativeDatesFilter() {
        return this.relativeDatesFilter;
    }

    public final TopBottomFilter topBottomFilter() {
        return this.topBottomFilter;
    }

    public final NestedFilter nestedFilter() {
        return this.nestedFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeDatesFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.topBottomFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nestedFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.categoryFilter(), other.categoryFilter()) && Objects.equals(this.numericRangeFilter(), other.numericRangeFilter()) && Objects.equals(this.numericEqualityFilter(), other.numericEqualityFilter()) && Objects.equals(this.timeEqualityFilter(), other.timeEqualityFilter()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter()) && Objects.equals(this.relativeDatesFilter(), other.relativeDatesFilter()) && Objects.equals(this.topBottomFilter(), other.topBottomFilter()) && Objects.equals(this.nestedFilter(), other.nestedFilter());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("CategoryFilter", (Object)this.categoryFilter()).add("NumericRangeFilter", (Object)this.numericRangeFilter()).add("NumericEqualityFilter", (Object)this.numericEqualityFilter()).add("TimeEqualityFilter", (Object)this.timeEqualityFilter()).add("TimeRangeFilter", (Object)this.timeRangeFilter()).add("RelativeDatesFilter", (Object)this.relativeDatesFilter()).add("TopBottomFilter", (Object)this.topBottomFilter()).add("NestedFilter", (Object)this.nestedFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryFilter": {
                return Optional.ofNullable(clazz.cast(this.categoryFilter()));
            }
            case "NumericRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.numericRangeFilter()));
            }
            case "NumericEqualityFilter": {
                return Optional.ofNullable(clazz.cast(this.numericEqualityFilter()));
            }
            case "TimeEqualityFilter": {
                return Optional.ofNullable(clazz.cast(this.timeEqualityFilter()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
            case "RelativeDatesFilter": {
                return Optional.ofNullable(clazz.cast(this.relativeDatesFilter()));
            }
            case "TopBottomFilter": {
                return Optional.ofNullable(clazz.cast(this.topBottomFilter()));
            }
            case "NestedFilter": {
                return Optional.ofNullable(clazz.cast(this.nestedFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CategoryFilter", CATEGORY_FILTER_FIELD);
        map.put("NumericRangeFilter", NUMERIC_RANGE_FILTER_FIELD);
        map.put("NumericEqualityFilter", NUMERIC_EQUALITY_FILTER_FIELD);
        map.put("TimeEqualityFilter", TIME_EQUALITY_FILTER_FIELD);
        map.put("TimeRangeFilter", TIME_RANGE_FILTER_FIELD);
        map.put("RelativeDatesFilter", RELATIVE_DATES_FILTER_FIELD);
        map.put("TopBottomFilter", TOP_BOTTOM_FILTER_FIELD);
        map.put("NestedFilter", NESTED_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CategoryFilter categoryFilter;
        private NumericRangeFilter numericRangeFilter;
        private NumericEqualityFilter numericEqualityFilter;
        private TimeEqualityFilter timeEqualityFilter;
        private TimeRangeFilter timeRangeFilter;
        private RelativeDatesFilter relativeDatesFilter;
        private TopBottomFilter topBottomFilter;
        private NestedFilter nestedFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.categoryFilter(model.categoryFilter);
            this.numericRangeFilter(model.numericRangeFilter);
            this.numericEqualityFilter(model.numericEqualityFilter);
            this.timeEqualityFilter(model.timeEqualityFilter);
            this.timeRangeFilter(model.timeRangeFilter);
            this.relativeDatesFilter(model.relativeDatesFilter);
            this.topBottomFilter(model.topBottomFilter);
            this.nestedFilter(model.nestedFilter);
        }

        public final CategoryFilter.Builder getCategoryFilter() {
            return this.categoryFilter != null ? this.categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(CategoryFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(CategoryFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final NumericRangeFilter.Builder getNumericRangeFilter() {
            return this.numericRangeFilter != null ? this.numericRangeFilter.toBuilder() : null;
        }

        public final void setNumericRangeFilter(NumericRangeFilter.BuilderImpl numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter != null ? numericRangeFilter.build() : null;
        }

        @Override
        public final Builder numericRangeFilter(NumericRangeFilter numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter;
            return this;
        }

        public final NumericEqualityFilter.Builder getNumericEqualityFilter() {
            return this.numericEqualityFilter != null ? this.numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(NumericEqualityFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(NumericEqualityFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final TimeEqualityFilter.Builder getTimeEqualityFilter() {
            return this.timeEqualityFilter != null ? this.timeEqualityFilter.toBuilder() : null;
        }

        public final void setTimeEqualityFilter(TimeEqualityFilter.BuilderImpl timeEqualityFilter) {
            this.timeEqualityFilter = timeEqualityFilter != null ? timeEqualityFilter.build() : null;
        }

        @Override
        public final Builder timeEqualityFilter(TimeEqualityFilter timeEqualityFilter) {
            this.timeEqualityFilter = timeEqualityFilter;
            return this;
        }

        public final TimeRangeFilter.Builder getTimeRangeFilter() {
            return this.timeRangeFilter != null ? this.timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilter.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilter timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public final RelativeDatesFilter.Builder getRelativeDatesFilter() {
            return this.relativeDatesFilter != null ? this.relativeDatesFilter.toBuilder() : null;
        }

        public final void setRelativeDatesFilter(RelativeDatesFilter.BuilderImpl relativeDatesFilter) {
            this.relativeDatesFilter = relativeDatesFilter != null ? relativeDatesFilter.build() : null;
        }

        @Override
        public final Builder relativeDatesFilter(RelativeDatesFilter relativeDatesFilter) {
            this.relativeDatesFilter = relativeDatesFilter;
            return this;
        }

        public final TopBottomFilter.Builder getTopBottomFilter() {
            return this.topBottomFilter != null ? this.topBottomFilter.toBuilder() : null;
        }

        public final void setTopBottomFilter(TopBottomFilter.BuilderImpl topBottomFilter) {
            this.topBottomFilter = topBottomFilter != null ? topBottomFilter.build() : null;
        }

        @Override
        public final Builder topBottomFilter(TopBottomFilter topBottomFilter) {
            this.topBottomFilter = topBottomFilter;
            return this;
        }

        public final NestedFilter.Builder getNestedFilter() {
            return this.nestedFilter != null ? this.nestedFilter.toBuilder() : null;
        }

        public final void setNestedFilter(NestedFilter.BuilderImpl nestedFilter) {
            this.nestedFilter = nestedFilter != null ? nestedFilter.build() : null;
        }

        @Override
        public final Builder nestedFilter(NestedFilter nestedFilter) {
            this.nestedFilter = nestedFilter;
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder categoryFilter(CategoryFilter var1);

        default public Builder categoryFilter(Consumer<CategoryFilter.Builder> categoryFilter) {
            return this.categoryFilter((CategoryFilter)((CategoryFilter.Builder)CategoryFilter.builder().applyMutation(categoryFilter)).build());
        }

        public Builder numericRangeFilter(NumericRangeFilter var1);

        default public Builder numericRangeFilter(Consumer<NumericRangeFilter.Builder> numericRangeFilter) {
            return this.numericRangeFilter((NumericRangeFilter)((NumericRangeFilter.Builder)NumericRangeFilter.builder().applyMutation(numericRangeFilter)).build());
        }

        public Builder numericEqualityFilter(NumericEqualityFilter var1);

        default public Builder numericEqualityFilter(Consumer<NumericEqualityFilter.Builder> numericEqualityFilter) {
            return this.numericEqualityFilter((NumericEqualityFilter)((NumericEqualityFilter.Builder)NumericEqualityFilter.builder().applyMutation(numericEqualityFilter)).build());
        }

        public Builder timeEqualityFilter(TimeEqualityFilter var1);

        default public Builder timeEqualityFilter(Consumer<TimeEqualityFilter.Builder> timeEqualityFilter) {
            return this.timeEqualityFilter((TimeEqualityFilter)((TimeEqualityFilter.Builder)TimeEqualityFilter.builder().applyMutation(timeEqualityFilter)).build());
        }

        public Builder timeRangeFilter(TimeRangeFilter var1);

        default public Builder timeRangeFilter(Consumer<TimeRangeFilter.Builder> timeRangeFilter) {
            return this.timeRangeFilter((TimeRangeFilter)((TimeRangeFilter.Builder)TimeRangeFilter.builder().applyMutation(timeRangeFilter)).build());
        }

        public Builder relativeDatesFilter(RelativeDatesFilter var1);

        default public Builder relativeDatesFilter(Consumer<RelativeDatesFilter.Builder> relativeDatesFilter) {
            return this.relativeDatesFilter((RelativeDatesFilter)((RelativeDatesFilter.Builder)RelativeDatesFilter.builder().applyMutation(relativeDatesFilter)).build());
        }

        public Builder topBottomFilter(TopBottomFilter var1);

        default public Builder topBottomFilter(Consumer<TopBottomFilter.Builder> topBottomFilter) {
            return this.topBottomFilter((TopBottomFilter)((TopBottomFilter.Builder)TopBottomFilter.builder().applyMutation(topBottomFilter)).build());
        }

        public Builder nestedFilter(NestedFilter var1);

        default public Builder nestedFilter(Consumer<NestedFilter.Builder> nestedFilter) {
            return this.nestedFilter((NestedFilter)((NestedFilter.Builder)NestedFilter.builder().applyMutation(nestedFilter)).build());
        }
    }
}

