/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetRefreshProperties;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataSetRefreshPropertiesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDataSetRefreshPropertiesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDataSetRefreshPropertiesResponse.getter(DescribeDataSetRefreshPropertiesResponse::requestId)).setter(DescribeDataSetRefreshPropertiesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDataSetRefreshPropertiesResponse.getter(DescribeDataSetRefreshPropertiesResponse::status)).setter(DescribeDataSetRefreshPropertiesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<DataSetRefreshProperties> DATA_SET_REFRESH_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSetRefreshProperties").getter(DescribeDataSetRefreshPropertiesResponse.getter(DescribeDataSetRefreshPropertiesResponse::dataSetRefreshProperties)).setter(DescribeDataSetRefreshPropertiesResponse.setter(Builder::dataSetRefreshProperties)).constructor(DataSetRefreshProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetRefreshProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, STATUS_FIELD, DATA_SET_REFRESH_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDataSetRefreshPropertiesResponse.memberNameToFieldInitializer();
    private final String requestId;
    private final Integer status;
    private final DataSetRefreshProperties dataSetRefreshProperties;

    private DescribeDataSetRefreshPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.dataSetRefreshProperties = builder.dataSetRefreshProperties;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final DataSetRefreshProperties dataSetRefreshProperties() {
        return this.dataSetRefreshProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetRefreshProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSetRefreshPropertiesResponse)) {
            return false;
        }
        DescribeDataSetRefreshPropertiesResponse other = (DescribeDataSetRefreshPropertiesResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.dataSetRefreshProperties(), other.dataSetRefreshProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataSetRefreshPropertiesResponse").add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("DataSetRefreshProperties", (Object)this.dataSetRefreshProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DataSetRefreshProperties": {
                return Optional.ofNullable(clazz.cast(this.dataSetRefreshProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DataSetRefreshProperties", DATA_SET_REFRESH_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSetRefreshPropertiesResponse, T> g) {
        return obj -> g.apply((DescribeDataSetRefreshPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String requestId;
        private Integer status;
        private DataSetRefreshProperties dataSetRefreshProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSetRefreshPropertiesResponse model) {
            super(model);
            this.requestId(model.requestId);
            this.status(model.status);
            this.dataSetRefreshProperties(model.dataSetRefreshProperties);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final DataSetRefreshProperties.Builder getDataSetRefreshProperties() {
            return this.dataSetRefreshProperties != null ? this.dataSetRefreshProperties.toBuilder() : null;
        }

        public final void setDataSetRefreshProperties(DataSetRefreshProperties.BuilderImpl dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties != null ? dataSetRefreshProperties.build() : null;
        }

        @Override
        public final Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        @Override
        public DescribeDataSetRefreshPropertiesResponse build() {
            return new DescribeDataSetRefreshPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataSetRefreshPropertiesResponse> {
        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder dataSetRefreshProperties(DataSetRefreshProperties var1);

        default public Builder dataSetRefreshProperties(Consumer<DataSetRefreshProperties.Builder> dataSetRefreshProperties) {
            return this.dataSetRefreshProperties((DataSetRefreshProperties)((DataSetRefreshProperties.Builder)DataSetRefreshProperties.builder().applyMutation(dataSetRefreshProperties)).build());
        }
    }
}

