/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used to restrict data based on a range of dates or times.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicDateRangeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicDateRangeFilter.Builder, TopicDateRangeFilter> {
    private static final SdkField<Boolean> INCLUSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inclusive").getter(getter(TopicDateRangeFilter::inclusive)).setter(setter(Builder::inclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inclusive").build()).build();

    private static final SdkField<TopicRangeFilterConstant> CONSTANT_FIELD = SdkField
            .<TopicRangeFilterConstant> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicDateRangeFilter::constant)).setter(setter(Builder::constant))
            .constructor(TopicRangeFilterConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSIVE_FIELD,
            CONSTANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean inclusive;

    private final TopicRangeFilterConstant constant;

    private TopicDateRangeFilter(BuilderImpl builder) {
        this.inclusive = builder.inclusive;
        this.constant = builder.constant;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the date range filter should include the boundary values. If set to true,
     * the filter includes the start and end dates. If set to false, the filter excludes them.
     * </p>
     * 
     * @return A Boolean value that indicates whether the date range filter should include the boundary values. If set
     *         to true, the filter includes the start and end dates. If set to false, the filter excludes them.
     */
    public final Boolean inclusive() {
        return inclusive;
    }

    /**
     * <p>
     * The constant used in a date range filter.
     * </p>
     * 
     * @return The constant used in a date range filter.
     */
    public final TopicRangeFilterConstant constant() {
        return constant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inclusive());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicDateRangeFilter)) {
            return false;
        }
        TopicDateRangeFilter other = (TopicDateRangeFilter) obj;
        return Objects.equals(inclusive(), other.inclusive()) && Objects.equals(constant(), other.constant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicDateRangeFilter").add("Inclusive", inclusive())
                .add("Constant", constant() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inclusive":
            return Optional.ofNullable(clazz.cast(inclusive()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Inclusive", INCLUSIVE_FIELD);
        map.put("Constant", CONSTANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicDateRangeFilter, T> g) {
        return obj -> g.apply((TopicDateRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicDateRangeFilter> {
        /**
         * <p>
         * A Boolean value that indicates whether the date range filter should include the boundary values. If set to
         * true, the filter includes the start and end dates. If set to false, the filter excludes them.
         * </p>
         * 
         * @param inclusive
         *        A Boolean value that indicates whether the date range filter should include the boundary values. If
         *        set to true, the filter includes the start and end dates. If set to false, the filter excludes them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusive(Boolean inclusive);

        /**
         * <p>
         * The constant used in a date range filter.
         * </p>
         * 
         * @param constant
         *        The constant used in a date range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicRangeFilterConstant constant);

        /**
         * <p>
         * The constant used in a date range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRangeFilterConstant.Builder}
         * avoiding the need to create one manually via {@link TopicRangeFilterConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRangeFilterConstant.Builder#build()} is called immediately
         * and its result is passed to {@link #constant(TopicRangeFilterConstant)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicRangeFilterConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicRangeFilterConstant)
         */
        default Builder constant(Consumer<TopicRangeFilterConstant.Builder> constant) {
            return constant(TopicRangeFilterConstant.builder().applyMutation(constant).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean inclusive;

        private TopicRangeFilterConstant constant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicDateRangeFilter model) {
            inclusive(model.inclusive);
            constant(model.constant);
        }

        public final Boolean getInclusive() {
            return inclusive;
        }

        public final void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Override
        public final Builder inclusive(Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final TopicRangeFilterConstant.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicRangeFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicRangeFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        @Override
        public TopicDateRangeFilter build() {
            return new TopicDateRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
