/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The image configuration of a table field URL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldImageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldImageConfiguration.Builder, TableFieldImageConfiguration> {
    private static final SdkField<TableCellImageSizingConfiguration> SIZING_OPTIONS_FIELD = SdkField
            .<TableCellImageSizingConfiguration> builder(MarshallingType.SDK_POJO).memberName("SizingOptions")
            .getter(getter(TableFieldImageConfiguration::sizingOptions)).setter(setter(Builder::sizingOptions))
            .constructor(TableCellImageSizingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZING_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableCellImageSizingConfiguration sizingOptions;

    private TableFieldImageConfiguration(BuilderImpl builder) {
        this.sizingOptions = builder.sizingOptions;
    }

    /**
     * <p>
     * The sizing options for the table image configuration.
     * </p>
     * 
     * @return The sizing options for the table image configuration.
     */
    public final TableCellImageSizingConfiguration sizingOptions() {
        return sizingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldImageConfiguration)) {
            return false;
        }
        TableFieldImageConfiguration other = (TableFieldImageConfiguration) obj;
        return Objects.equals(sizingOptions(), other.sizingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldImageConfiguration").add("SizingOptions", sizingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizingOptions":
            return Optional.ofNullable(clazz.cast(sizingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SizingOptions", SIZING_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldImageConfiguration, T> g) {
        return obj -> g.apply((TableFieldImageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldImageConfiguration> {
        /**
         * <p>
         * The sizing options for the table image configuration.
         * </p>
         * 
         * @param sizingOptions
         *        The sizing options for the table image configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizingOptions(TableCellImageSizingConfiguration sizingOptions);

        /**
         * <p>
         * The sizing options for the table image configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TableCellImageSizingConfiguration.Builder} avoiding the need to create one manually via
         * {@link TableCellImageSizingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellImageSizingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sizingOptions(TableCellImageSizingConfiguration)}.
         * 
         * @param sizingOptions
         *        a consumer that will call methods on {@link TableCellImageSizingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizingOptions(TableCellImageSizingConfiguration)
         */
        default Builder sizingOptions(Consumer<TableCellImageSizingConfiguration.Builder> sizingOptions) {
            return sizingOptions(TableCellImageSizingConfiguration.builder().applyMutation(sizingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableCellImageSizingConfiguration sizingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldImageConfiguration model) {
            sizingOptions(model.sizingOptions);
        }

        public final TableCellImageSizingConfiguration.Builder getSizingOptions() {
            return sizingOptions != null ? sizingOptions.toBuilder() : null;
        }

        public final void setSizingOptions(TableCellImageSizingConfiguration.BuilderImpl sizingOptions) {
            this.sizingOptions = sizingOptions != null ? sizingOptions.build() : null;
        }

        @Override
        public final Builder sizingOptions(TableCellImageSizingConfiguration sizingOptions) {
            this.sizingOptions = sizingOptions;
            return this;
        }

        @Override
        public TableFieldImageConfiguration build() {
            return new TableFieldImageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
