/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for Snowflake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeParameters.Builder, SnowflakeParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(SnowflakeParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(SnowflakeParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Warehouse").getter(getter(SnowflakeParameters::warehouse)).setter(setter(Builder::warehouse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warehouse").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(SnowflakeParameters::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> DATABASE_ACCESS_CONTROL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseAccessControlRole").getter(getter(SnowflakeParameters::databaseAccessControlRole))
            .setter(setter(Builder::databaseAccessControlRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseAccessControlRole").build())
            .build();

    private static final SdkField<OAuthParameters> O_AUTH_PARAMETERS_FIELD = SdkField
            .<OAuthParameters> builder(MarshallingType.SDK_POJO).memberName("OAuthParameters")
            .getter(getter(SnowflakeParameters::oAuthParameters)).setter(setter(Builder::oAuthParameters))
            .constructor(OAuthParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, DATABASE_FIELD,
            WAREHOUSE_FIELD, AUTHENTICATION_TYPE_FIELD, DATABASE_ACCESS_CONTROL_ROLE_FIELD, O_AUTH_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String host;

    private final String database;

    private final String warehouse;

    private final String authenticationType;

    private final String databaseAccessControlRole;

    private final OAuthParameters oAuthParameters;

    private SnowflakeParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.database = builder.database;
        this.warehouse = builder.warehouse;
        this.authenticationType = builder.authenticationType;
        this.databaseAccessControlRole = builder.databaseAccessControlRole;
        this.oAuthParameters = builder.oAuthParameters;
    }

    /**
     * <p>
     * Host.
     * </p>
     * 
     * @return Host.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * Database.
     * </p>
     * 
     * @return Database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * Warehouse.
     * </p>
     * 
     * @return Warehouse.
     */
    public final String warehouse() {
        return warehouse;
    }

    /**
     * <p>
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
     * authentication types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that you want to use for your connection. This parameter accepts OAuth and
     *         non-OAuth authentication types.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
     * authentication types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that you want to use for your connection. This parameter accepts OAuth and
     *         non-OAuth authentication types.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The database access control role.
     * </p>
     * 
     * @return The database access control role.
     */
    public final String databaseAccessControlRole() {
        return databaseAccessControlRole;
    }

    /**
     * <p>
     * An object that contains information needed to create a data source connection between an QuickSight account and
     * Snowflake.
     * </p>
     * 
     * @return An object that contains information needed to create a data source connection between an QuickSight
     *         account and Snowflake.
     */
    public final OAuthParameters oAuthParameters() {
        return oAuthParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(warehouse());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseAccessControlRole());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeParameters)) {
            return false;
        }
        SnowflakeParameters other = (SnowflakeParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(database(), other.database())
                && Objects.equals(warehouse(), other.warehouse())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(databaseAccessControlRole(), other.databaseAccessControlRole())
                && Objects.equals(oAuthParameters(), other.oAuthParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeParameters").add("Host", host()).add("Database", database())
                .add("Warehouse", warehouse()).add("AuthenticationType", authenticationTypeAsString())
                .add("DatabaseAccessControlRole", databaseAccessControlRole()).add("OAuthParameters", oAuthParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Warehouse":
            return Optional.ofNullable(clazz.cast(warehouse()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "DatabaseAccessControlRole":
            return Optional.ofNullable(clazz.cast(databaseAccessControlRole()));
        case "OAuthParameters":
            return Optional.ofNullable(clazz.cast(oAuthParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Host", HOST_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Warehouse", WAREHOUSE_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("DatabaseAccessControlRole", DATABASE_ACCESS_CONTROL_ROLE_FIELD);
        map.put("OAuthParameters", O_AUTH_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeParameters, T> g) {
        return obj -> g.apply((SnowflakeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeParameters> {
        /**
         * <p>
         * Host.
         * </p>
         * 
         * @param host
         *        Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * Database.
         * </p>
         * 
         * @param database
         *        Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Warehouse.
         * </p>
         * 
         * @param warehouse
         *        Warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warehouse(String warehouse);

        /**
         * <p>
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
         * authentication types.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that you want to use for your connection. This parameter accepts OAuth and
         *        non-OAuth authentication types.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
         * authentication types.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that you want to use for your connection. This parameter accepts OAuth and
         *        non-OAuth authentication types.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The database access control role.
         * </p>
         * 
         * @param databaseAccessControlRole
         *        The database access control role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseAccessControlRole(String databaseAccessControlRole);

        /**
         * <p>
         * An object that contains information needed to create a data source connection between an QuickSight account
         * and Snowflake.
         * </p>
         * 
         * @param oAuthParameters
         *        An object that contains information needed to create a data source connection between an QuickSight
         *        account and Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthParameters(OAuthParameters oAuthParameters);

        /**
         * <p>
         * An object that contains information needed to create a data source connection between an QuickSight account
         * and Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthParameters.Builder} avoiding the
         * need to create one manually via {@link OAuthParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuthParameters(OAuthParameters)}.
         * 
         * @param oAuthParameters
         *        a consumer that will call methods on {@link OAuthParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthParameters(OAuthParameters)
         */
        default Builder oAuthParameters(Consumer<OAuthParameters.Builder> oAuthParameters) {
            return oAuthParameters(OAuthParameters.builder().applyMutation(oAuthParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private String database;

        private String warehouse;

        private String authenticationType;

        private String databaseAccessControlRole;

        private OAuthParameters oAuthParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeParameters model) {
            host(model.host);
            database(model.database);
            warehouse(model.warehouse);
            authenticationType(model.authenticationType);
            databaseAccessControlRole(model.databaseAccessControlRole);
            oAuthParameters(model.oAuthParameters);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getWarehouse() {
            return warehouse;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Override
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getDatabaseAccessControlRole() {
            return databaseAccessControlRole;
        }

        public final void setDatabaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
        }

        @Override
        public final Builder databaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
            return this;
        }

        public final OAuthParameters.Builder getOAuthParameters() {
            return oAuthParameters != null ? oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(OAuthParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(OAuthParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        @Override
        public SnowflakeParameters build() {
            return new SnowflakeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
