/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings of a chart's single axis configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleAxisOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleAxisOptions.Builder, SingleAxisOptions> {
    private static final SdkField<YAxisOptions> Y_AXIS_OPTIONS_FIELD = SdkField.<YAxisOptions> builder(MarshallingType.SDK_POJO)
            .memberName("YAxisOptions").getter(getter(SingleAxisOptions::yAxisOptions)).setter(setter(Builder::yAxisOptions))
            .constructor(YAxisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(Y_AXIS_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final YAxisOptions yAxisOptions;

    private SingleAxisOptions(BuilderImpl builder) {
        this.yAxisOptions = builder.yAxisOptions;
    }

    /**
     * <p>
     * The Y axis options of a single axis configuration.
     * </p>
     * 
     * @return The Y axis options of a single axis configuration.
     */
    public final YAxisOptions yAxisOptions() {
        return yAxisOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(yAxisOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleAxisOptions)) {
            return false;
        }
        SingleAxisOptions other = (SingleAxisOptions) obj;
        return Objects.equals(yAxisOptions(), other.yAxisOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleAxisOptions").add("YAxisOptions", yAxisOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "YAxisOptions":
            return Optional.ofNullable(clazz.cast(yAxisOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("YAxisOptions", Y_AXIS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SingleAxisOptions, T> g) {
        return obj -> g.apply((SingleAxisOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleAxisOptions> {
        /**
         * <p>
         * The Y axis options of a single axis configuration.
         * </p>
         * 
         * @param yAxisOptions
         *        The Y axis options of a single axis configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxisOptions(YAxisOptions yAxisOptions);

        /**
         * <p>
         * The Y axis options of a single axis configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link YAxisOptions.Builder} avoiding the need
         * to create one manually via {@link YAxisOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link YAxisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #yAxisOptions(YAxisOptions)}.
         * 
         * @param yAxisOptions
         *        a consumer that will call methods on {@link YAxisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxisOptions(YAxisOptions)
         */
        default Builder yAxisOptions(Consumer<YAxisOptions.Builder> yAxisOptions) {
            return yAxisOptions(YAxisOptions.builder().applyMutation(yAxisOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private YAxisOptions yAxisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleAxisOptions model) {
            yAxisOptions(model.yAxisOptions);
        }

        public final YAxisOptions.Builder getYAxisOptions() {
            return yAxisOptions != null ? yAxisOptions.toBuilder() : null;
        }

        public final void setYAxisOptions(YAxisOptions.BuilderImpl yAxisOptions) {
            this.yAxisOptions = yAxisOptions != null ? yAxisOptions.build() : null;
        }

        @Override
        public final Builder yAxisOptions(YAxisOptions yAxisOptions) {
            this.yAxisOptions = yAxisOptions;
            return this;
        }

        @Override
        public SingleAxisOptions build() {
            return new SingleAxisOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
