/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total options for a pivot table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableTotalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableTotalOptions.Builder, PivotTableTotalOptions> {
    private static final SdkField<SubtotalOptions> ROW_SUBTOTAL_OPTIONS_FIELD = SdkField
            .<SubtotalOptions> builder(MarshallingType.SDK_POJO).memberName("RowSubtotalOptions")
            .getter(getter(PivotTableTotalOptions::rowSubtotalOptions)).setter(setter(Builder::rowSubtotalOptions))
            .constructor(SubtotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSubtotalOptions").build())
            .build();

    private static final SdkField<SubtotalOptions> COLUMN_SUBTOTAL_OPTIONS_FIELD = SdkField
            .<SubtotalOptions> builder(MarshallingType.SDK_POJO).memberName("ColumnSubtotalOptions")
            .getter(getter(PivotTableTotalOptions::columnSubtotalOptions)).setter(setter(Builder::columnSubtotalOptions))
            .constructor(SubtotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSubtotalOptions").build())
            .build();

    private static final SdkField<PivotTotalOptions> ROW_TOTAL_OPTIONS_FIELD = SdkField
            .<PivotTotalOptions> builder(MarshallingType.SDK_POJO).memberName("RowTotalOptions")
            .getter(getter(PivotTableTotalOptions::rowTotalOptions)).setter(setter(Builder::rowTotalOptions))
            .constructor(PivotTotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTotalOptions").build()).build();

    private static final SdkField<PivotTotalOptions> COLUMN_TOTAL_OPTIONS_FIELD = SdkField
            .<PivotTotalOptions> builder(MarshallingType.SDK_POJO).memberName("ColumnTotalOptions")
            .getter(getter(PivotTableTotalOptions::columnTotalOptions)).setter(setter(Builder::columnTotalOptions))
            .constructor(PivotTotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnTotalOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SUBTOTAL_OPTIONS_FIELD,
            COLUMN_SUBTOTAL_OPTIONS_FIELD, ROW_TOTAL_OPTIONS_FIELD, COLUMN_TOTAL_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SubtotalOptions rowSubtotalOptions;

    private final SubtotalOptions columnSubtotalOptions;

    private final PivotTotalOptions rowTotalOptions;

    private final PivotTotalOptions columnTotalOptions;

    private PivotTableTotalOptions(BuilderImpl builder) {
        this.rowSubtotalOptions = builder.rowSubtotalOptions;
        this.columnSubtotalOptions = builder.columnSubtotalOptions;
        this.rowTotalOptions = builder.rowTotalOptions;
        this.columnTotalOptions = builder.columnTotalOptions;
    }

    /**
     * <p>
     * The row subtotal options.
     * </p>
     * 
     * @return The row subtotal options.
     */
    public final SubtotalOptions rowSubtotalOptions() {
        return rowSubtotalOptions;
    }

    /**
     * <p>
     * The column subtotal options.
     * </p>
     * 
     * @return The column subtotal options.
     */
    public final SubtotalOptions columnSubtotalOptions() {
        return columnSubtotalOptions;
    }

    /**
     * <p>
     * The row total options.
     * </p>
     * 
     * @return The row total options.
     */
    public final PivotTotalOptions rowTotalOptions() {
        return rowTotalOptions;
    }

    /**
     * <p>
     * The column total options.
     * </p>
     * 
     * @return The column total options.
     */
    public final PivotTotalOptions columnTotalOptions() {
        return columnTotalOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowSubtotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(columnSubtotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(rowTotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(columnTotalOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableTotalOptions)) {
            return false;
        }
        PivotTableTotalOptions other = (PivotTableTotalOptions) obj;
        return Objects.equals(rowSubtotalOptions(), other.rowSubtotalOptions())
                && Objects.equals(columnSubtotalOptions(), other.columnSubtotalOptions())
                && Objects.equals(rowTotalOptions(), other.rowTotalOptions())
                && Objects.equals(columnTotalOptions(), other.columnTotalOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableTotalOptions").add("RowSubtotalOptions", rowSubtotalOptions())
                .add("ColumnSubtotalOptions", columnSubtotalOptions()).add("RowTotalOptions", rowTotalOptions())
                .add("ColumnTotalOptions", columnTotalOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowSubtotalOptions":
            return Optional.ofNullable(clazz.cast(rowSubtotalOptions()));
        case "ColumnSubtotalOptions":
            return Optional.ofNullable(clazz.cast(columnSubtotalOptions()));
        case "RowTotalOptions":
            return Optional.ofNullable(clazz.cast(rowTotalOptions()));
        case "ColumnTotalOptions":
            return Optional.ofNullable(clazz.cast(columnTotalOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RowSubtotalOptions", ROW_SUBTOTAL_OPTIONS_FIELD);
        map.put("ColumnSubtotalOptions", COLUMN_SUBTOTAL_OPTIONS_FIELD);
        map.put("RowTotalOptions", ROW_TOTAL_OPTIONS_FIELD);
        map.put("ColumnTotalOptions", COLUMN_TOTAL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableTotalOptions, T> g) {
        return obj -> g.apply((PivotTableTotalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableTotalOptions> {
        /**
         * <p>
         * The row subtotal options.
         * </p>
         * 
         * @param rowSubtotalOptions
         *        The row subtotal options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSubtotalOptions(SubtotalOptions rowSubtotalOptions);

        /**
         * <p>
         * The row subtotal options.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubtotalOptions.Builder} avoiding the
         * need to create one manually via {@link SubtotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubtotalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #rowSubtotalOptions(SubtotalOptions)}.
         * 
         * @param rowSubtotalOptions
         *        a consumer that will call methods on {@link SubtotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowSubtotalOptions(SubtotalOptions)
         */
        default Builder rowSubtotalOptions(Consumer<SubtotalOptions.Builder> rowSubtotalOptions) {
            return rowSubtotalOptions(SubtotalOptions.builder().applyMutation(rowSubtotalOptions).build());
        }

        /**
         * <p>
         * The column subtotal options.
         * </p>
         * 
         * @param columnSubtotalOptions
         *        The column subtotal options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSubtotalOptions(SubtotalOptions columnSubtotalOptions);

        /**
         * <p>
         * The column subtotal options.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubtotalOptions.Builder} avoiding the
         * need to create one manually via {@link SubtotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubtotalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #columnSubtotalOptions(SubtotalOptions)}.
         * 
         * @param columnSubtotalOptions
         *        a consumer that will call methods on {@link SubtotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnSubtotalOptions(SubtotalOptions)
         */
        default Builder columnSubtotalOptions(Consumer<SubtotalOptions.Builder> columnSubtotalOptions) {
            return columnSubtotalOptions(SubtotalOptions.builder().applyMutation(columnSubtotalOptions).build());
        }

        /**
         * <p>
         * The row total options.
         * </p>
         * 
         * @param rowTotalOptions
         *        The row total options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowTotalOptions(PivotTotalOptions rowTotalOptions);

        /**
         * <p>
         * The row total options.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTotalOptions.Builder} avoiding the
         * need to create one manually via {@link PivotTotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTotalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #rowTotalOptions(PivotTotalOptions)}.
         * 
         * @param rowTotalOptions
         *        a consumer that will call methods on {@link PivotTotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowTotalOptions(PivotTotalOptions)
         */
        default Builder rowTotalOptions(Consumer<PivotTotalOptions.Builder> rowTotalOptions) {
            return rowTotalOptions(PivotTotalOptions.builder().applyMutation(rowTotalOptions).build());
        }

        /**
         * <p>
         * The column total options.
         * </p>
         * 
         * @param columnTotalOptions
         *        The column total options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTotalOptions(PivotTotalOptions columnTotalOptions);

        /**
         * <p>
         * The column total options.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTotalOptions.Builder} avoiding the
         * need to create one manually via {@link PivotTotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTotalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #columnTotalOptions(PivotTotalOptions)}.
         * 
         * @param columnTotalOptions
         *        a consumer that will call methods on {@link PivotTotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnTotalOptions(PivotTotalOptions)
         */
        default Builder columnTotalOptions(Consumer<PivotTotalOptions.Builder> columnTotalOptions) {
            return columnTotalOptions(PivotTotalOptions.builder().applyMutation(columnTotalOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SubtotalOptions rowSubtotalOptions;

        private SubtotalOptions columnSubtotalOptions;

        private PivotTotalOptions rowTotalOptions;

        private PivotTotalOptions columnTotalOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableTotalOptions model) {
            rowSubtotalOptions(model.rowSubtotalOptions);
            columnSubtotalOptions(model.columnSubtotalOptions);
            rowTotalOptions(model.rowTotalOptions);
            columnTotalOptions(model.columnTotalOptions);
        }

        public final SubtotalOptions.Builder getRowSubtotalOptions() {
            return rowSubtotalOptions != null ? rowSubtotalOptions.toBuilder() : null;
        }

        public final void setRowSubtotalOptions(SubtotalOptions.BuilderImpl rowSubtotalOptions) {
            this.rowSubtotalOptions = rowSubtotalOptions != null ? rowSubtotalOptions.build() : null;
        }

        @Override
        public final Builder rowSubtotalOptions(SubtotalOptions rowSubtotalOptions) {
            this.rowSubtotalOptions = rowSubtotalOptions;
            return this;
        }

        public final SubtotalOptions.Builder getColumnSubtotalOptions() {
            return columnSubtotalOptions != null ? columnSubtotalOptions.toBuilder() : null;
        }

        public final void setColumnSubtotalOptions(SubtotalOptions.BuilderImpl columnSubtotalOptions) {
            this.columnSubtotalOptions = columnSubtotalOptions != null ? columnSubtotalOptions.build() : null;
        }

        @Override
        public final Builder columnSubtotalOptions(SubtotalOptions columnSubtotalOptions) {
            this.columnSubtotalOptions = columnSubtotalOptions;
            return this;
        }

        public final PivotTotalOptions.Builder getRowTotalOptions() {
            return rowTotalOptions != null ? rowTotalOptions.toBuilder() : null;
        }

        public final void setRowTotalOptions(PivotTotalOptions.BuilderImpl rowTotalOptions) {
            this.rowTotalOptions = rowTotalOptions != null ? rowTotalOptions.build() : null;
        }

        @Override
        public final Builder rowTotalOptions(PivotTotalOptions rowTotalOptions) {
            this.rowTotalOptions = rowTotalOptions;
            return this;
        }

        public final PivotTotalOptions.Builder getColumnTotalOptions() {
            return columnTotalOptions != null ? columnTotalOptions.toBuilder() : null;
        }

        public final void setColumnTotalOptions(PivotTotalOptions.BuilderImpl columnTotalOptions) {
            this.columnTotalOptions = columnTotalOptions != null ? columnTotalOptions.build() : null;
        }

        @Override
        public final Builder columnTotalOptions(PivotTotalOptions columnTotalOptions) {
            this.columnTotalOptions = columnTotalOptions;
            return this;
        }

        @Override
        public PivotTableTotalOptions build() {
            return new PivotTableTotalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
