/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NestedFilter implements SdkPojo, Serializable, ToCopyableBuilder<NestedFilter.Builder, NestedFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(NestedFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(NestedFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Boolean> INCLUDE_INNER_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeInnerSet").getter(getter(NestedFilter::includeInnerSet)).setter(setter(Builder::includeInnerSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeInnerSet").build()).build();

    private static final SdkField<InnerFilter> INNER_FILTER_FIELD = SdkField.<InnerFilter> builder(MarshallingType.SDK_POJO)
            .memberName("InnerFilter").getter(getter(NestedFilter::innerFilter)).setter(setter(Builder::innerFilter))
            .constructor(InnerFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InnerFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            INCLUDE_INNER_SET_FIELD, INNER_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Boolean includeInnerSet;

    private final InnerFilter innerFilter;

    private NestedFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeInnerSet = builder.includeInnerSet;
        this.innerFilter = builder.innerFilter;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * A boolean condition to include or exclude the subset that is defined by the values of the nested inner filter.
     * </p>
     * 
     * @return A boolean condition to include or exclude the subset that is defined by the values of the nested inner
     *         filter.
     */
    public final Boolean includeInnerSet() {
        return includeInnerSet;
    }

    /**
     * <p>
     * The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
     * </p>
     * 
     * @return The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
     */
    public final InnerFilter innerFilter() {
        return innerFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(includeInnerSet());
        hashCode = 31 * hashCode + Objects.hashCode(innerFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NestedFilter)) {
            return false;
        }
        NestedFilter other = (NestedFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(includeInnerSet(), other.includeInnerSet())
                && Objects.equals(innerFilter(), other.innerFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NestedFilter").add("FilterId", filterId()).add("Column", column())
                .add("IncludeInnerSet", includeInnerSet()).add("InnerFilter", innerFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "IncludeInnerSet":
            return Optional.ofNullable(clazz.cast(includeInnerSet()));
        case "InnerFilter":
            return Optional.ofNullable(clazz.cast(innerFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("IncludeInnerSet", INCLUDE_INNER_SET_FIELD);
        map.put("InnerFilter", INNER_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NestedFilter, T> g) {
        return obj -> g.apply((NestedFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NestedFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * A boolean condition to include or exclude the subset that is defined by the values of the nested inner
         * filter.
         * </p>
         * 
         * @param includeInnerSet
         *        A boolean condition to include or exclude the subset that is defined by the values of the nested inner
         *        filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInnerSet(Boolean includeInnerSet);

        /**
         * <p>
         * The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
         * </p>
         * 
         * @param innerFilter
         *        The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder innerFilter(InnerFilter innerFilter);

        /**
         * <p>
         * The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InnerFilter.Builder} avoiding the need to
         * create one manually via {@link InnerFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InnerFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #innerFilter(InnerFilter)}.
         * 
         * @param innerFilter
         *        a consumer that will call methods on {@link InnerFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #innerFilter(InnerFilter)
         */
        default Builder innerFilter(Consumer<InnerFilter.Builder> innerFilter) {
            return innerFilter(InnerFilter.builder().applyMutation(innerFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Boolean includeInnerSet;

        private InnerFilter innerFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(NestedFilter model) {
            filterId(model.filterId);
            column(model.column);
            includeInnerSet(model.includeInnerSet);
            innerFilter(model.innerFilter);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeInnerSet() {
            return includeInnerSet;
        }

        public final void setIncludeInnerSet(Boolean includeInnerSet) {
            this.includeInnerSet = includeInnerSet;
        }

        @Override
        public final Builder includeInnerSet(Boolean includeInnerSet) {
            this.includeInnerSet = includeInnerSet;
            return this;
        }

        public final InnerFilter.Builder getInnerFilter() {
            return innerFilter != null ? innerFilter.toBuilder() : null;
        }

        public final void setInnerFilter(InnerFilter.BuilderImpl innerFilter) {
            this.innerFilter = innerFilter != null ? innerFilter.build() : null;
        }

        @Override
        public final Builder innerFilter(InnerFilter innerFilter) {
            this.innerFilter = innerFilter;
            return this;
        }

        @Override
        public NestedFilter build() {
            return new NestedFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
