/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The map style options of the geospatial map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialMapStyleOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialMapStyleOptions.Builder, GeospatialMapStyleOptions> {
    private static final SdkField<String> BASE_MAP_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseMapStyle").getter(getter(GeospatialMapStyleOptions::baseMapStyleAsString))
            .setter(setter(Builder::baseMapStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseMapStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_MAP_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseMapStyle;

    private GeospatialMapStyleOptions(BuilderImpl builder) {
        this.baseMapStyle = builder.baseMapStyle;
    }

    /**
     * <p>
     * The base map style of the geospatial map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapStyle} will
     * return {@link BaseMapStyleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapStyleAsString}.
     * </p>
     * 
     * @return The base map style of the geospatial map.
     * @see BaseMapStyleType
     */
    public final BaseMapStyleType baseMapStyle() {
        return BaseMapStyleType.fromValue(baseMapStyle);
    }

    /**
     * <p>
     * The base map style of the geospatial map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapStyle} will
     * return {@link BaseMapStyleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapStyleAsString}.
     * </p>
     * 
     * @return The base map style of the geospatial map.
     * @see BaseMapStyleType
     */
    public final String baseMapStyleAsString() {
        return baseMapStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseMapStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapStyleOptions)) {
            return false;
        }
        GeospatialMapStyleOptions other = (GeospatialMapStyleOptions) obj;
        return Objects.equals(baseMapStyleAsString(), other.baseMapStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialMapStyleOptions").add("BaseMapStyle", baseMapStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseMapStyle":
            return Optional.ofNullable(clazz.cast(baseMapStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseMapStyle", BASE_MAP_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapStyleOptions, T> g) {
        return obj -> g.apply((GeospatialMapStyleOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialMapStyleOptions> {
        /**
         * <p>
         * The base map style of the geospatial map.
         * </p>
         * 
         * @param baseMapStyle
         *        The base map style of the geospatial map.
         * @see BaseMapStyleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseMapStyleType
         */
        Builder baseMapStyle(String baseMapStyle);

        /**
         * <p>
         * The base map style of the geospatial map.
         * </p>
         * 
         * @param baseMapStyle
         *        The base map style of the geospatial map.
         * @see BaseMapStyleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseMapStyleType
         */
        Builder baseMapStyle(BaseMapStyleType baseMapStyle);
    }

    static final class BuilderImpl implements Builder {
        private String baseMapStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapStyleOptions model) {
            baseMapStyle(model.baseMapStyle);
        }

        public final String getBaseMapStyle() {
            return baseMapStyle;
        }

        public final void setBaseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
        }

        @Override
        public final Builder baseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
            return this;
        }

        @Override
        public final Builder baseMapStyle(BaseMapStyleType baseMapStyle) {
            this.baseMapStyle(baseMapStyle == null ? null : baseMapStyle.toString());
            return this;
        }

        @Override
        public GeospatialMapStyleOptions build() {
            return new GeospatialMapStyleOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
