/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The map definition that defines map state, map style, and geospatial layers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLayerMapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLayerMapConfiguration.Builder, GeospatialLayerMapConfiguration> {
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(GeospatialLayerMapConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<List<GeospatialLayerItem>> MAP_LAYERS_FIELD = SdkField
            .<List<GeospatialLayerItem>> builder(MarshallingType.LIST)
            .memberName("MapLayers")
            .getter(getter(GeospatialLayerMapConfiguration::mapLayers))
            .setter(setter(Builder::mapLayers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapLayers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeospatialLayerItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeospatialLayerItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GeospatialMapState> MAP_STATE_FIELD = SdkField
            .<GeospatialMapState> builder(MarshallingType.SDK_POJO).memberName("MapState")
            .getter(getter(GeospatialLayerMapConfiguration::mapState)).setter(setter(Builder::mapState))
            .constructor(GeospatialMapState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapState").build()).build();

    private static final SdkField<GeospatialMapStyle> MAP_STYLE_FIELD = SdkField
            .<GeospatialMapStyle> builder(MarshallingType.SDK_POJO).memberName("MapStyle")
            .getter(getter(GeospatialLayerMapConfiguration::mapStyle)).setter(setter(Builder::mapStyle))
            .constructor(GeospatialMapStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapStyle").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(GeospatialLayerMapConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGEND_FIELD,
            MAP_LAYERS_FIELD, MAP_STATE_FIELD, MAP_STYLE_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LegendOptions legend;

    private final List<GeospatialLayerItem> mapLayers;

    private final GeospatialMapState mapState;

    private final GeospatialMapStyle mapStyle;

    private final VisualInteractionOptions interactions;

    private GeospatialLayerMapConfiguration(BuilderImpl builder) {
        this.legend = builder.legend;
        this.mapLayers = builder.mapLayers;
        this.mapState = builder.mapState;
        this.mapStyle = builder.mapStyle;
        this.interactions = builder.interactions;
    }

    /**
     * Returns the value of the Legend property for this object.
     * 
     * @return The value of the Legend property for this object.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapLayers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapLayers() {
        return mapLayers != null && !(mapLayers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The geospatial layers to visualize on the map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapLayers} method.
     * </p>
     * 
     * @return The geospatial layers to visualize on the map.
     */
    public final List<GeospatialLayerItem> mapLayers() {
        return mapLayers;
    }

    /**
     * <p>
     * The map state properties for the map.
     * </p>
     * 
     * @return The map state properties for the map.
     */
    public final GeospatialMapState mapState() {
        return mapState;
    }

    /**
     * <p>
     * The map style properties for the map.
     * </p>
     * 
     * @return The map style properties for the map.
     */
    public final GeospatialMapStyle mapStyle() {
        return mapStyle;
    }

    /**
     * Returns the value of the Interactions property for this object.
     * 
     * @return The value of the Interactions property for this object.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(hasMapLayers() ? mapLayers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mapState());
        hashCode = 31 * hashCode + Objects.hashCode(mapStyle());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerMapConfiguration)) {
            return false;
        }
        GeospatialLayerMapConfiguration other = (GeospatialLayerMapConfiguration) obj;
        return Objects.equals(legend(), other.legend()) && hasMapLayers() == other.hasMapLayers()
                && Objects.equals(mapLayers(), other.mapLayers()) && Objects.equals(mapState(), other.mapState())
                && Objects.equals(mapStyle(), other.mapStyle()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLayerMapConfiguration").add("Legend", legend())
                .add("MapLayers", hasMapLayers() ? mapLayers() : null).add("MapState", mapState()).add("MapStyle", mapStyle())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "MapLayers":
            return Optional.ofNullable(clazz.cast(mapLayers()));
        case "MapState":
            return Optional.ofNullable(clazz.cast(mapState()));
        case "MapStyle":
            return Optional.ofNullable(clazz.cast(mapStyle()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Legend", LEGEND_FIELD);
        map.put("MapLayers", MAP_LAYERS_FIELD);
        map.put("MapState", MAP_STATE_FIELD);
        map.put("MapStyle", MAP_STYLE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerMapConfiguration, T> g) {
        return obj -> g.apply((GeospatialLayerMapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLayerMapConfiguration> {
        /**
         * Sets the value of the Legend property for this object.
         *
         * @param legend
         *        The new value for the Legend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * Sets the value of the Legend property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The geospatial layers to visualize on the map.
         * </p>
         * 
         * @param mapLayers
         *        The geospatial layers to visualize on the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapLayers(Collection<GeospatialLayerItem> mapLayers);

        /**
         * <p>
         * The geospatial layers to visualize on the map.
         * </p>
         * 
         * @param mapLayers
         *        The geospatial layers to visualize on the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapLayers(GeospatialLayerItem... mapLayers);

        /**
         * <p>
         * The geospatial layers to visualize on the map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialLayerItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialLayerItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialLayerItem.Builder#build()} is called
         * immediately and its result is passed to {@link #mapLayers(List<GeospatialLayerItem>)}.
         * 
         * @param mapLayers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.GeospatialLayerItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapLayers(java.util.Collection<GeospatialLayerItem>)
         */
        Builder mapLayers(Consumer<GeospatialLayerItem.Builder>... mapLayers);

        /**
         * <p>
         * The map state properties for the map.
         * </p>
         * 
         * @param mapState
         *        The map state properties for the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapState(GeospatialMapState mapState);

        /**
         * <p>
         * The map state properties for the map.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapState.Builder} avoiding the
         * need to create one manually via {@link GeospatialMapState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapState.Builder#build()} is called immediately and its
         * result is passed to {@link #mapState(GeospatialMapState)}.
         * 
         * @param mapState
         *        a consumer that will call methods on {@link GeospatialMapState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapState(GeospatialMapState)
         */
        default Builder mapState(Consumer<GeospatialMapState.Builder> mapState) {
            return mapState(GeospatialMapState.builder().applyMutation(mapState).build());
        }

        /**
         * <p>
         * The map style properties for the map.
         * </p>
         * 
         * @param mapStyle
         *        The map style properties for the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapStyle(GeospatialMapStyle mapStyle);

        /**
         * <p>
         * The map style properties for the map.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapStyle.Builder} avoiding the
         * need to create one manually via {@link GeospatialMapStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #mapStyle(GeospatialMapStyle)}.
         * 
         * @param mapStyle
         *        a consumer that will call methods on {@link GeospatialMapStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapStyle(GeospatialMapStyle)
         */
        default Builder mapStyle(Consumer<GeospatialMapStyle.Builder> mapStyle) {
            return mapStyle(GeospatialMapStyle.builder().applyMutation(mapStyle).build());
        }

        /**
         * Sets the value of the Interactions property for this object.
         *
         * @param interactions
         *        The new value for the Interactions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * Sets the value of the Interactions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LegendOptions legend;

        private List<GeospatialLayerItem> mapLayers = DefaultSdkAutoConstructList.getInstance();

        private GeospatialMapState mapState;

        private GeospatialMapStyle mapStyle;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerMapConfiguration model) {
            legend(model.legend);
            mapLayers(model.mapLayers);
            mapState(model.mapState);
            mapStyle(model.mapStyle);
            interactions(model.interactions);
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final List<GeospatialLayerItem.Builder> getMapLayers() {
            List<GeospatialLayerItem.Builder> result = GeospatialMapLayerListCopier.copyToBuilder(this.mapLayers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapLayers(Collection<GeospatialLayerItem.BuilderImpl> mapLayers) {
            this.mapLayers = GeospatialMapLayerListCopier.copyFromBuilder(mapLayers);
        }

        @Override
        public final Builder mapLayers(Collection<GeospatialLayerItem> mapLayers) {
            this.mapLayers = GeospatialMapLayerListCopier.copy(mapLayers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapLayers(GeospatialLayerItem... mapLayers) {
            mapLayers(Arrays.asList(mapLayers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapLayers(Consumer<GeospatialLayerItem.Builder>... mapLayers) {
            mapLayers(Stream.of(mapLayers).map(c -> GeospatialLayerItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GeospatialMapState.Builder getMapState() {
            return mapState != null ? mapState.toBuilder() : null;
        }

        public final void setMapState(GeospatialMapState.BuilderImpl mapState) {
            this.mapState = mapState != null ? mapState.build() : null;
        }

        @Override
        public final Builder mapState(GeospatialMapState mapState) {
            this.mapState = mapState;
            return this;
        }

        public final GeospatialMapStyle.Builder getMapStyle() {
            return mapStyle != null ? mapStyle.toBuilder() : null;
        }

        public final void setMapStyle(GeospatialMapStyle.BuilderImpl mapStyle) {
            this.mapStyle = mapStyle != null ? mapStyle.build() : null;
        }

        @Override
        public final Builder mapStyle(GeospatialMapStyle mapStyle) {
            this.mapStyle = mapStyle;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public GeospatialLayerMapConfiguration build() {
            return new GeospatialLayerMapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
