/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data source properties for the geospatial data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialDataSourceItem implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialDataSourceItem.Builder, GeospatialDataSourceItem> {
    private static final SdkField<GeospatialStaticFileSource> STATIC_FILE_DATA_SOURCE_FIELD = SdkField
            .<GeospatialStaticFileSource> builder(MarshallingType.SDK_POJO).memberName("StaticFileDataSource")
            .getter(getter(GeospatialDataSourceItem::staticFileDataSource)).setter(setter(Builder::staticFileDataSource))
            .constructor(GeospatialStaticFileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticFileDataSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATIC_FILE_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialStaticFileSource staticFileDataSource;

    private GeospatialDataSourceItem(BuilderImpl builder) {
        this.staticFileDataSource = builder.staticFileDataSource;
    }

    /**
     * <p>
     * The static file data source properties for the geospatial data.
     * </p>
     * 
     * @return The static file data source properties for the geospatial data.
     */
    public final GeospatialStaticFileSource staticFileDataSource() {
        return staticFileDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticFileDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialDataSourceItem)) {
            return false;
        }
        GeospatialDataSourceItem other = (GeospatialDataSourceItem) obj;
        return Objects.equals(staticFileDataSource(), other.staticFileDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialDataSourceItem").add("StaticFileDataSource", staticFileDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticFileDataSource":
            return Optional.ofNullable(clazz.cast(staticFileDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StaticFileDataSource", STATIC_FILE_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialDataSourceItem, T> g) {
        return obj -> g.apply((GeospatialDataSourceItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialDataSourceItem> {
        /**
         * <p>
         * The static file data source properties for the geospatial data.
         * </p>
         * 
         * @param staticFileDataSource
         *        The static file data source properties for the geospatial data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticFileDataSource(GeospatialStaticFileSource staticFileDataSource);

        /**
         * <p>
         * The static file data source properties for the geospatial data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialStaticFileSource.Builder}
         * avoiding the need to create one manually via {@link GeospatialStaticFileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialStaticFileSource.Builder#build()} is called immediately
         * and its result is passed to {@link #staticFileDataSource(GeospatialStaticFileSource)}.
         * 
         * @param staticFileDataSource
         *        a consumer that will call methods on {@link GeospatialStaticFileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticFileDataSource(GeospatialStaticFileSource)
         */
        default Builder staticFileDataSource(Consumer<GeospatialStaticFileSource.Builder> staticFileDataSource) {
            return staticFileDataSource(GeospatialStaticFileSource.builder().applyMutation(staticFileDataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialStaticFileSource staticFileDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialDataSourceItem model) {
            staticFileDataSource(model.staticFileDataSource);
        }

        public final GeospatialStaticFileSource.Builder getStaticFileDataSource() {
            return staticFileDataSource != null ? staticFileDataSource.toBuilder() : null;
        }

        public final void setStaticFileDataSource(GeospatialStaticFileSource.BuilderImpl staticFileDataSource) {
            this.staticFileDataSource = staticFileDataSource != null ? staticFileDataSource.build() : null;
        }

        @Override
        public final Builder staticFileDataSource(GeospatialStaticFileSource staticFileDataSource) {
            this.staticFileDataSource = staticFileDataSource;
            return this;
        }

        @Override
        public GeospatialDataSourceItem build() {
            return new GeospatialDataSourceItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
