/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The background style configuration of a free-form layout element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeFormLayoutElementBackgroundStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<FreeFormLayoutElementBackgroundStyle.Builder, FreeFormLayoutElementBackgroundStyle> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(FreeFormLayoutElementBackgroundStyle::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(FreeFormLayoutElementBackgroundStyle::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VISIBILITY_FIELD, COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String color;

    private FreeFormLayoutElementBackgroundStyle(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.color = builder.color;
    }

    /**
     * <p>
     * The background visibility of a free-form layout element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The background visibility of a free-form layout element.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The background visibility of a free-form layout element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The background visibility of a free-form layout element.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The background color of a free-form layout element.
     * </p>
     * 
     * @return The background color of a free-form layout element.
     */
    public final String color() {
        return color;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormLayoutElementBackgroundStyle)) {
            return false;
        }
        FreeFormLayoutElementBackgroundStyle other = (FreeFormLayoutElementBackgroundStyle) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString()) && Objects.equals(color(), other.color());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeFormLayoutElementBackgroundStyle").add("Visibility", visibilityAsString())
                .add("Color", color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Color", COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeFormLayoutElementBackgroundStyle, T> g) {
        return obj -> g.apply((FreeFormLayoutElementBackgroundStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeFormLayoutElementBackgroundStyle> {
        /**
         * <p>
         * The background visibility of a free-form layout element.
         * </p>
         * 
         * @param visibility
         *        The background visibility of a free-form layout element.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The background visibility of a free-form layout element.
         * </p>
         * 
         * @param visibility
         *        The background visibility of a free-form layout element.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The background color of a free-form layout element.
         * </p>
         * 
         * @param color
         *        The background color of a free-form layout element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String color;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeFormLayoutElementBackgroundStyle model) {
            visibility(model.visibility);
            color(model.color);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        @Override
        public FreeFormLayoutElementBackgroundStyle build() {
            return new FreeFormLayoutElementBackgroundStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
