/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The forecast computation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<ForecastComputation.Builder, ForecastComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(ForecastComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ForecastComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DimensionField> TIME_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Time").getter(getter(ForecastComputation::time)).setter(setter(Builder::time))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(ForecastComputation::value)).setter(setter(Builder::value))
            .constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Integer> PERIODS_FORWARD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodsForward").getter(getter(ForecastComputation::periodsForward))
            .setter(setter(Builder::periodsForward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsForward").build()).build();

    private static final SdkField<Integer> PERIODS_BACKWARD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodsBackward").getter(getter(ForecastComputation::periodsBackward))
            .setter(setter(Builder::periodsBackward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsBackward").build()).build();

    private static final SdkField<Double> UPPER_BOUNDARY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UpperBoundary").getter(getter(ForecastComputation::upperBoundary))
            .setter(setter(Builder::upperBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBoundary").build()).build();

    private static final SdkField<Double> LOWER_BOUNDARY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LowerBoundary").getter(getter(ForecastComputation::lowerBoundary))
            .setter(setter(Builder::lowerBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBoundary").build()).build();

    private static final SdkField<Integer> PREDICTION_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PredictionInterval").getter(getter(ForecastComputation::predictionInterval))
            .setter(setter(Builder::predictionInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionInterval").build())
            .build();

    private static final SdkField<String> SEASONALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Seasonality").getter(getter(ForecastComputation::seasonalityAsString))
            .setter(setter(Builder::seasonality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seasonality").build()).build();

    private static final SdkField<Integer> CUSTOM_SEASONALITY_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CustomSeasonalityValue").getter(getter(ForecastComputation::customSeasonalityValue))
            .setter(setter(Builder::customSeasonalityValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSeasonalityValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, TIME_FIELD, VALUE_FIELD, PERIODS_FORWARD_FIELD, PERIODS_BACKWARD_FIELD, UPPER_BOUNDARY_FIELD,
            LOWER_BOUNDARY_FIELD, PREDICTION_INTERVAL_FIELD, SEASONALITY_FIELD, CUSTOM_SEASONALITY_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final DimensionField time;

    private final MeasureField value;

    private final Integer periodsForward;

    private final Integer periodsBackward;

    private final Double upperBoundary;

    private final Double lowerBoundary;

    private final Integer predictionInterval;

    private final String seasonality;

    private final Integer customSeasonalityValue;

    private ForecastComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.time = builder.time;
        this.value = builder.value;
        this.periodsForward = builder.periodsForward;
        this.periodsBackward = builder.periodsBackward;
        this.upperBoundary = builder.upperBoundary;
        this.lowerBoundary = builder.lowerBoundary;
        this.predictionInterval = builder.predictionInterval;
        this.seasonality = builder.seasonality;
        this.customSeasonalityValue = builder.customSeasonalityValue;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time field that is used in a computation.
     * </p>
     * 
     * @return The time field that is used in a computation.
     */
    public final DimensionField time() {
        return time;
    }

    /**
     * <p>
     * The value field that is used in a computation.
     * </p>
     * 
     * @return The value field that is used in a computation.
     */
    public final MeasureField value() {
        return value;
    }

    /**
     * <p>
     * The periods forward setup of a forecast computation.
     * </p>
     * 
     * @return The periods forward setup of a forecast computation.
     */
    public final Integer periodsForward() {
        return periodsForward;
    }

    /**
     * <p>
     * The periods backward setup of a forecast computation.
     * </p>
     * 
     * @return The periods backward setup of a forecast computation.
     */
    public final Integer periodsBackward() {
        return periodsBackward;
    }

    /**
     * <p>
     * The upper boundary setup of a forecast computation.
     * </p>
     * 
     * @return The upper boundary setup of a forecast computation.
     */
    public final Double upperBoundary() {
        return upperBoundary;
    }

    /**
     * <p>
     * The lower boundary setup of a forecast computation.
     * </p>
     * 
     * @return The lower boundary setup of a forecast computation.
     */
    public final Double lowerBoundary() {
        return lowerBoundary;
    }

    /**
     * <p>
     * The prediction interval setup of a forecast computation.
     * </p>
     * 
     * @return The prediction interval setup of a forecast computation.
     */
    public final Integer predictionInterval() {
        return predictionInterval;
    }

    /**
     * <p>
     * The seasonality setup of a forecast computation. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTOMATIC</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code>: Checks the custom seasonality value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #seasonality} will
     * return {@link ForecastComputationSeasonality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #seasonalityAsString}.
     * </p>
     * 
     * @return The seasonality setup of a forecast computation. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTOMATIC</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code>: Checks the custom seasonality value.
     *         </p>
     *         </li>
     * @see ForecastComputationSeasonality
     */
    public final ForecastComputationSeasonality seasonality() {
        return ForecastComputationSeasonality.fromValue(seasonality);
    }

    /**
     * <p>
     * The seasonality setup of a forecast computation. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTOMATIC</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code>: Checks the custom seasonality value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #seasonality} will
     * return {@link ForecastComputationSeasonality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #seasonalityAsString}.
     * </p>
     * 
     * @return The seasonality setup of a forecast computation. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTOMATIC</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code>: Checks the custom seasonality value.
     *         </p>
     *         </li>
     * @see ForecastComputationSeasonality
     */
    public final String seasonalityAsString() {
        return seasonality;
    }

    /**
     * <p>
     * The custom seasonality value setup of a forecast computation.
     * </p>
     * 
     * @return The custom seasonality value setup of a forecast computation.
     */
    public final Integer customSeasonalityValue() {
        return customSeasonalityValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(periodsForward());
        hashCode = 31 * hashCode + Objects.hashCode(periodsBackward());
        hashCode = 31 * hashCode + Objects.hashCode(upperBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(lowerBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(predictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(seasonalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customSeasonalityValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastComputation)) {
            return false;
        }
        ForecastComputation other = (ForecastComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(time(), other.time()) && Objects.equals(value(), other.value())
                && Objects.equals(periodsForward(), other.periodsForward())
                && Objects.equals(periodsBackward(), other.periodsBackward())
                && Objects.equals(upperBoundary(), other.upperBoundary())
                && Objects.equals(lowerBoundary(), other.lowerBoundary())
                && Objects.equals(predictionInterval(), other.predictionInterval())
                && Objects.equals(seasonalityAsString(), other.seasonalityAsString())
                && Objects.equals(customSeasonalityValue(), other.customSeasonalityValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Time", time()).add("Value", value()).add("PeriodsForward", periodsForward())
                .add("PeriodsBackward", periodsBackward()).add("UpperBoundary", upperBoundary())
                .add("LowerBoundary", lowerBoundary()).add("PredictionInterval", predictionInterval())
                .add("Seasonality", seasonalityAsString()).add("CustomSeasonalityValue", customSeasonalityValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "PeriodsForward":
            return Optional.ofNullable(clazz.cast(periodsForward()));
        case "PeriodsBackward":
            return Optional.ofNullable(clazz.cast(periodsBackward()));
        case "UpperBoundary":
            return Optional.ofNullable(clazz.cast(upperBoundary()));
        case "LowerBoundary":
            return Optional.ofNullable(clazz.cast(lowerBoundary()));
        case "PredictionInterval":
            return Optional.ofNullable(clazz.cast(predictionInterval()));
        case "Seasonality":
            return Optional.ofNullable(clazz.cast(seasonalityAsString()));
        case "CustomSeasonalityValue":
            return Optional.ofNullable(clazz.cast(customSeasonalityValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputationId", COMPUTATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Time", TIME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("PeriodsForward", PERIODS_FORWARD_FIELD);
        map.put("PeriodsBackward", PERIODS_BACKWARD_FIELD);
        map.put("UpperBoundary", UPPER_BOUNDARY_FIELD);
        map.put("LowerBoundary", LOWER_BOUNDARY_FIELD);
        map.put("PredictionInterval", PREDICTION_INTERVAL_FIELD);
        map.put("Seasonality", SEASONALITY_FIELD);
        map.put("CustomSeasonalityValue", CUSTOM_SEASONALITY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastComputation, T> g) {
        return obj -> g.apply((ForecastComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * 
         * @param time
         *        The time field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(DimensionField time);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #time(DimensionField)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(DimensionField)
         */
        default Builder time(Consumer<DimensionField.Builder> time) {
            return time(DimensionField.builder().applyMutation(time).build());
        }

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * 
         * @param value
         *        The value field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MeasureField value);

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MeasureField)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MeasureField)
         */
        default Builder value(Consumer<MeasureField.Builder> value) {
            return value(MeasureField.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The periods forward setup of a forecast computation.
         * </p>
         * 
         * @param periodsForward
         *        The periods forward setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodsForward(Integer periodsForward);

        /**
         * <p>
         * The periods backward setup of a forecast computation.
         * </p>
         * 
         * @param periodsBackward
         *        The periods backward setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodsBackward(Integer periodsBackward);

        /**
         * <p>
         * The upper boundary setup of a forecast computation.
         * </p>
         * 
         * @param upperBoundary
         *        The upper boundary setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBoundary(Double upperBoundary);

        /**
         * <p>
         * The lower boundary setup of a forecast computation.
         * </p>
         * 
         * @param lowerBoundary
         *        The lower boundary setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBoundary(Double lowerBoundary);

        /**
         * <p>
         * The prediction interval setup of a forecast computation.
         * </p>
         * 
         * @param predictionInterval
         *        The prediction interval setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionInterval(Integer predictionInterval);

        /**
         * <p>
         * The seasonality setup of a forecast computation. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTOMATIC</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code>: Checks the custom seasonality value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param seasonality
         *        The seasonality setup of a forecast computation. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTOMATIC</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code>: Checks the custom seasonality value.
         *        </p>
         *        </li>
         * @see ForecastComputationSeasonality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForecastComputationSeasonality
         */
        Builder seasonality(String seasonality);

        /**
         * <p>
         * The seasonality setup of a forecast computation. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTOMATIC</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code>: Checks the custom seasonality value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param seasonality
         *        The seasonality setup of a forecast computation. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTOMATIC</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code>: Checks the custom seasonality value.
         *        </p>
         *        </li>
         * @see ForecastComputationSeasonality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForecastComputationSeasonality
         */
        Builder seasonality(ForecastComputationSeasonality seasonality);

        /**
         * <p>
         * The custom seasonality value setup of a forecast computation.
         * </p>
         * 
         * @param customSeasonalityValue
         *        The custom seasonality value setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSeasonalityValue(Integer customSeasonalityValue);
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private DimensionField time;

        private MeasureField value;

        private Integer periodsForward;

        private Integer periodsBackward;

        private Double upperBoundary;

        private Double lowerBoundary;

        private Integer predictionInterval;

        private String seasonality;

        private Integer customSeasonalityValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastComputation model) {
            computationId(model.computationId);
            name(model.name);
            time(model.time);
            value(model.value);
            periodsForward(model.periodsForward);
            periodsBackward(model.periodsBackward);
            upperBoundary(model.upperBoundary);
            lowerBoundary(model.lowerBoundary);
            predictionInterval(model.predictionInterval);
            seasonality(model.seasonality);
            customSeasonalityValue(model.customSeasonalityValue);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(DimensionField.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(DimensionField time) {
            this.time = time;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        public final Integer getPeriodsForward() {
            return periodsForward;
        }

        public final void setPeriodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
        }

        @Override
        public final Builder periodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
            return this;
        }

        public final Integer getPeriodsBackward() {
            return periodsBackward;
        }

        public final void setPeriodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
        }

        @Override
        public final Builder periodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
            return this;
        }

        public final Double getUpperBoundary() {
            return upperBoundary;
        }

        public final void setUpperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        @Override
        public final Builder upperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
            return this;
        }

        public final Double getLowerBoundary() {
            return lowerBoundary;
        }

        public final void setLowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        @Override
        public final Builder lowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
            return this;
        }

        public final Integer getPredictionInterval() {
            return predictionInterval;
        }

        public final void setPredictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
        }

        @Override
        public final Builder predictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
            return this;
        }

        public final String getSeasonality() {
            return seasonality;
        }

        public final void setSeasonality(String seasonality) {
            this.seasonality = seasonality;
        }

        @Override
        public final Builder seasonality(String seasonality) {
            this.seasonality = seasonality;
            return this;
        }

        @Override
        public final Builder seasonality(ForecastComputationSeasonality seasonality) {
            this.seasonality(seasonality == null ? null : seasonality.toString());
            return this;
        }

        public final Integer getCustomSeasonalityValue() {
            return customSeasonalityValue;
        }

        public final void setCustomSeasonalityValue(Integer customSeasonalityValue) {
            this.customSeasonalityValue = customSeasonalityValue;
        }

        @Override
        public final Builder customSeasonalityValue(Integer customSeasonalityValue) {
            this.customSeasonalityValue = customSeasonalityValue;
            return this;
        }

        @Override
        public ForecastComputation build() {
            return new ForecastComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
