/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the default settings for a grid layout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultGridLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultGridLayoutConfiguration.Builder, DefaultGridLayoutConfiguration> {
    private static final SdkField<GridLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<GridLayoutCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("CanvasSizeOptions")
            .getter(getter(DefaultGridLayoutConfiguration::canvasSizeOptions)).setter(setter(Builder::canvasSizeOptions))
            .constructor(GridLayoutCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANVAS_SIZE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GridLayoutCanvasSizeOptions canvasSizeOptions;

    private DefaultGridLayoutConfiguration(BuilderImpl builder) {
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    /**
     * <p>
     * Determines the screen canvas size options for a grid layout.
     * </p>
     * 
     * @return Determines the screen canvas size options for a grid layout.
     */
    public final GridLayoutCanvasSizeOptions canvasSizeOptions() {
        return canvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultGridLayoutConfiguration)) {
            return false;
        }
        DefaultGridLayoutConfiguration other = (DefaultGridLayoutConfiguration) obj;
        return Objects.equals(canvasSizeOptions(), other.canvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultGridLayoutConfiguration").add("CanvasSizeOptions", canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(canvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CanvasSizeOptions", CANVAS_SIZE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultGridLayoutConfiguration, T> g) {
        return obj -> g.apply((DefaultGridLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultGridLayoutConfiguration> {
        /**
         * <p>
         * Determines the screen canvas size options for a grid layout.
         * </p>
         * 
         * @param canvasSizeOptions
         *        Determines the screen canvas size options for a grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canvasSizeOptions(GridLayoutCanvasSizeOptions canvasSizeOptions);

        /**
         * <p>
         * Determines the screen canvas size options for a grid layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link GridLayoutCanvasSizeOptions.Builder}
         * avoiding the need to create one manually via {@link GridLayoutCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridLayoutCanvasSizeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #canvasSizeOptions(GridLayoutCanvasSizeOptions)}.
         * 
         * @param canvasSizeOptions
         *        a consumer that will call methods on {@link GridLayoutCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canvasSizeOptions(GridLayoutCanvasSizeOptions)
         */
        default Builder canvasSizeOptions(Consumer<GridLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return canvasSizeOptions(GridLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GridLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultGridLayoutConfiguration model) {
            canvasSizeOptions(model.canvasSizeOptions);
        }

        public final GridLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return canvasSizeOptions != null ? canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(GridLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(GridLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        @Override
        public DefaultGridLayoutConfiguration build() {
            return new DefaultGridLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
