/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting configuration for solid color.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingSolidColor implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingSolidColor.Builder, ConditionalFormattingSolidColor> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(ConditionalFormattingSolidColor::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(ConditionalFormattingSolidColor::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXPRESSION_FIELD, COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final String color;

    private ConditionalFormattingSolidColor(BuilderImpl builder) {
        this.expression = builder.expression;
        this.color = builder.color;
    }

    /**
     * <p>
     * The expression that determines the formatting configuration for solid color.
     * </p>
     * 
     * @return The expression that determines the formatting configuration for solid color.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * Determines the color.
     * </p>
     * 
     * @return Determines the color.
     */
    public final String color() {
        return color;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingSolidColor)) {
            return false;
        }
        ConditionalFormattingSolidColor other = (ConditionalFormattingSolidColor) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(color(), other.color());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingSolidColor")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").add("Color", color()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Color", COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingSolidColor, T> g) {
        return obj -> g.apply((ConditionalFormattingSolidColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingSolidColor> {
        /**
         * <p>
         * The expression that determines the formatting configuration for solid color.
         * </p>
         * 
         * @param expression
         *        The expression that determines the formatting configuration for solid color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Determines the color.
         * </p>
         * 
         * @param color
         *        Determines the color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private String color;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingSolidColor model) {
            expression(model.expression);
            color(model.color);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        @Override
        public ConditionalFormattingSolidColor build() {
            return new ConditionalFormattingSolidColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
