/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents the cell value synonym.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CellValueSynonym implements SdkPojo, Serializable,
        ToCopyableBuilder<CellValueSynonym.Builder, CellValueSynonym> {
    private static final SdkField<String> CELL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CellValue").getter(getter(CellValueSynonym::cellValue)).setter(setter(Builder::cellValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValue").build()).build();

    private static final SdkField<List<String>> SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Synonyms")
            .getter(getter(CellValueSynonym::synonyms))
            .setter(setter(Builder::synonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Synonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_VALUE_FIELD,
            SYNONYMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cellValue;

    private final List<String> synonyms;

    private CellValueSynonym(BuilderImpl builder) {
        this.cellValue = builder.cellValue;
        this.synonyms = builder.synonyms;
    }

    /**
     * <p>
     * The cell value.
     * </p>
     * 
     * @return The cell value.
     */
    public final String cellValue() {
        return cellValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Synonyms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSynonyms() {
        return synonyms != null && !(synonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Other names or aliases for the cell value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSynonyms} method.
     * </p>
     * 
     * @return Other names or aliases for the cell value.
     */
    public final List<String> synonyms() {
        return synonyms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cellValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasSynonyms() ? synonyms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValueSynonym)) {
            return false;
        }
        CellValueSynonym other = (CellValueSynonym) obj;
        return Objects.equals(cellValue(), other.cellValue()) && hasSynonyms() == other.hasSynonyms()
                && Objects.equals(synonyms(), other.synonyms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CellValueSynonym").add("CellValue", cellValue())
                .add("Synonyms", hasSynonyms() ? synonyms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CellValue":
            return Optional.ofNullable(clazz.cast(cellValue()));
        case "Synonyms":
            return Optional.ofNullable(clazz.cast(synonyms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CellValue", CELL_VALUE_FIELD);
        map.put("Synonyms", SYNONYMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CellValueSynonym, T> g) {
        return obj -> g.apply((CellValueSynonym) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CellValueSynonym> {
        /**
         * <p>
         * The cell value.
         * </p>
         * 
         * @param cellValue
         *        The cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellValue(String cellValue);

        /**
         * <p>
         * Other names or aliases for the cell value.
         * </p>
         * 
         * @param synonyms
         *        Other names or aliases for the cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(Collection<String> synonyms);

        /**
         * <p>
         * Other names or aliases for the cell value.
         * </p>
         * 
         * @param synonyms
         *        Other names or aliases for the cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(String... synonyms);
    }

    static final class BuilderImpl implements Builder {
        private String cellValue;

        private List<String> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CellValueSynonym model) {
            cellValue(model.cellValue);
            synonyms(model.synonyms);
        }

        public final String getCellValue() {
            return cellValue;
        }

        public final void setCellValue(String cellValue) {
            this.cellValue = cellValue;
        }

        @Override
        public final Builder cellValue(String cellValue) {
            this.cellValue = cellValue;
            return this;
        }

        public final Collection<String> getSynonyms() {
            if (synonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return synonyms;
        }

        public final void setSynonyms(Collection<String> synonyms) {
            this.synonyms = StringListCopier.copy(synonyms);
        }

        @Override
        public final Builder synonyms(Collection<String> synonyms) {
            this.synonyms = StringListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(String... synonyms) {
            synonyms(Arrays.asList(synonyms));
            return this;
        }

        @Override
        public CellValueSynonym build() {
            return new CellValueSynonym(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
