/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of overrides that modify the asset bundle resource configuration before the resource is imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobOverrideParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobOverrideParameters.Builder, AssetBundleImportJobOverrideParameters> {
    private static final SdkField<AssetBundleImportJobResourceIdOverrideConfiguration> RESOURCE_ID_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<AssetBundleImportJobResourceIdOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceIdOverrideConfiguration")
            .getter(getter(AssetBundleImportJobOverrideParameters::resourceIdOverrideConfiguration))
            .setter(setter(Builder::resourceIdOverrideConfiguration))
            .constructor(AssetBundleImportJobResourceIdOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdOverrideConfiguration")
                    .build()).build();

    private static final SdkField<List<AssetBundleImportJobVPCConnectionOverrideParameters>> VPC_CONNECTIONS_FIELD = SdkField
            .<List<AssetBundleImportJobVPCConnectionOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("VPCConnections")
            .getter(getter(AssetBundleImportJobOverrideParameters::vpcConnections))
            .setter(setter(Builder::vpcConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobVPCConnectionOverrideParameters> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobVPCConnectionOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobRefreshScheduleOverrideParameters>> REFRESH_SCHEDULES_FIELD = SdkField
            .<List<AssetBundleImportJobRefreshScheduleOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("RefreshSchedules")
            .getter(getter(AssetBundleImportJobOverrideParameters::refreshSchedules))
            .setter(setter(Builder::refreshSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobRefreshScheduleOverrideParameters> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobRefreshScheduleOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDataSourceOverrideParameters>> DATA_SOURCES_FIELD = SdkField
            .<List<AssetBundleImportJobDataSourceOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(AssetBundleImportJobOverrideParameters::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSourceOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSourceOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDataSetOverrideParameters>> DATA_SETS_FIELD = SdkField
            .<List<AssetBundleImportJobDataSetOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("DataSets")
            .getter(getter(AssetBundleImportJobOverrideParameters::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSetOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSetOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobThemeOverrideParameters>> THEMES_FIELD = SdkField
            .<List<AssetBundleImportJobThemeOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("Themes")
            .getter(getter(AssetBundleImportJobOverrideParameters::themes))
            .setter(setter(Builder::themes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Themes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobThemeOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobThemeOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobAnalysisOverrideParameters>> ANALYSES_FIELD = SdkField
            .<List<AssetBundleImportJobAnalysisOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("Analyses")
            .getter(getter(AssetBundleImportJobOverrideParameters::analyses))
            .setter(setter(Builder::analyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobAnalysisOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobAnalysisOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDashboardOverrideParameters>> DASHBOARDS_FIELD = SdkField
            .<List<AssetBundleImportJobDashboardOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("Dashboards")
            .getter(getter(AssetBundleImportJobOverrideParameters::dashboards))
            .setter(setter(Builder::dashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDashboardOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDashboardOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobFolderOverrideParameters>> FOLDERS_FIELD = SdkField
            .<List<AssetBundleImportJobFolderOverrideParameters>> builder(MarshallingType.LIST)
            .memberName("Folders")
            .getter(getter(AssetBundleImportJobOverrideParameters::folders))
            .setter(setter(Builder::folders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobFolderOverrideParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobFolderOverrideParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_ID_OVERRIDE_CONFIGURATION_FIELD, VPC_CONNECTIONS_FIELD, REFRESH_SCHEDULES_FIELD, DATA_SOURCES_FIELD,
            DATA_SETS_FIELD, THEMES_FIELD, ANALYSES_FIELD, DASHBOARDS_FIELD, FOLDERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetBundleImportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration;

    private final List<AssetBundleImportJobVPCConnectionOverrideParameters> vpcConnections;

    private final List<AssetBundleImportJobRefreshScheduleOverrideParameters> refreshSchedules;

    private final List<AssetBundleImportJobDataSourceOverrideParameters> dataSources;

    private final List<AssetBundleImportJobDataSetOverrideParameters> dataSets;

    private final List<AssetBundleImportJobThemeOverrideParameters> themes;

    private final List<AssetBundleImportJobAnalysisOverrideParameters> analyses;

    private final List<AssetBundleImportJobDashboardOverrideParameters> dashboards;

    private final List<AssetBundleImportJobFolderOverrideParameters> folders;

    private AssetBundleImportJobOverrideParameters(BuilderImpl builder) {
        this.resourceIdOverrideConfiguration = builder.resourceIdOverrideConfiguration;
        this.vpcConnections = builder.vpcConnections;
        this.refreshSchedules = builder.refreshSchedules;
        this.dataSources = builder.dataSources;
        this.dataSets = builder.dataSets;
        this.themes = builder.themes;
        this.analyses = builder.analyses;
        this.dashboards = builder.dashboards;
        this.folders = builder.folders;
    }

    /**
     * <p>
     * An optional structure that configures resource ID overrides to be applied within the import job.
     * </p>
     * 
     * @return An optional structure that configures resource ID overrides to be applied within the import job.
     */
    public final AssetBundleImportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration() {
        return resourceIdOverrideConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the VPCConnections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcConnections() {
        return vpcConnections != null && !(vpcConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConnections} method.
     * </p>
     * 
     * @return A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobVPCConnectionOverrideParameters> vpcConnections() {
        return vpcConnections;
    }

    /**
     * For responses, this returns true if the service returned a value for the RefreshSchedules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRefreshSchedules() {
        return refreshSchedules != null && !(refreshSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRefreshSchedules} method.
     * </p>
     * 
     * @return A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobRefreshScheduleOverrideParameters> refreshSchedules() {
        return refreshSchedules;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that
     *         is imported.
     */
    public final List<AssetBundleImportJobDataSourceOverrideParameters> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobDataSetOverrideParameters> dataSets() {
        return dataSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Themes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThemes() {
        return themes != null && !(themes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThemes} method.
     * </p>
     * 
     * @return A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobThemeOverrideParameters> themes() {
        return themes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Analyses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnalyses() {
        return analyses != null && !(analyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyses} method.
     * </p>
     * 
     * @return A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobAnalysisOverrideParameters> analyses() {
        return analyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dashboards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDashboards() {
        return dashboards != null && !(dashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboards} method.
     * </p>
     * 
     * @return A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobDashboardOverrideParameters> dashboards() {
        return dashboards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Folders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolders() {
        return folders != null && !(folders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolders} method.
     * </p>
     * 
     * @return A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobFolderOverrideParameters> folders() {
        return folders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConnections() ? vpcConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRefreshSchedules() ? refreshSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThemes() ? themes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyses() ? analyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboards() ? dashboards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFolders() ? folders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobOverrideParameters other = (AssetBundleImportJobOverrideParameters) obj;
        return Objects.equals(resourceIdOverrideConfiguration(), other.resourceIdOverrideConfiguration())
                && hasVpcConnections() == other.hasVpcConnections() && Objects.equals(vpcConnections(), other.vpcConnections())
                && hasRefreshSchedules() == other.hasRefreshSchedules()
                && Objects.equals(refreshSchedules(), other.refreshSchedules()) && hasDataSources() == other.hasDataSources()
                && Objects.equals(dataSources(), other.dataSources()) && hasDataSets() == other.hasDataSets()
                && Objects.equals(dataSets(), other.dataSets()) && hasThemes() == other.hasThemes()
                && Objects.equals(themes(), other.themes()) && hasAnalyses() == other.hasAnalyses()
                && Objects.equals(analyses(), other.analyses()) && hasDashboards() == other.hasDashboards()
                && Objects.equals(dashboards(), other.dashboards()) && hasFolders() == other.hasFolders()
                && Objects.equals(folders(), other.folders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobOverrideParameters")
                .add("ResourceIdOverrideConfiguration", resourceIdOverrideConfiguration())
                .add("VPCConnections", hasVpcConnections() ? vpcConnections() : null)
                .add("RefreshSchedules", hasRefreshSchedules() ? refreshSchedules() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null).add("DataSets", hasDataSets() ? dataSets() : null)
                .add("Themes", hasThemes() ? themes() : null).add("Analyses", hasAnalyses() ? analyses() : null)
                .add("Dashboards", hasDashboards() ? dashboards() : null).add("Folders", hasFolders() ? folders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(resourceIdOverrideConfiguration()));
        case "VPCConnections":
            return Optional.ofNullable(clazz.cast(vpcConnections()));
        case "RefreshSchedules":
            return Optional.ofNullable(clazz.cast(refreshSchedules()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "Themes":
            return Optional.ofNullable(clazz.cast(themes()));
        case "Analyses":
            return Optional.ofNullable(clazz.cast(analyses()));
        case "Dashboards":
            return Optional.ofNullable(clazz.cast(dashboards()));
        case "Folders":
            return Optional.ofNullable(clazz.cast(folders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceIdOverrideConfiguration", RESOURCE_ID_OVERRIDE_CONFIGURATION_FIELD);
        map.put("VPCConnections", VPC_CONNECTIONS_FIELD);
        map.put("RefreshSchedules", REFRESH_SCHEDULES_FIELD);
        map.put("DataSources", DATA_SOURCES_FIELD);
        map.put("DataSets", DATA_SETS_FIELD);
        map.put("Themes", THEMES_FIELD);
        map.put("Analyses", ANALYSES_FIELD);
        map.put("Dashboards", DASHBOARDS_FIELD);
        map.put("Folders", FOLDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobOverrideParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobOverrideParameters> {
        /**
         * <p>
         * An optional structure that configures resource ID overrides to be applied within the import job.
         * </p>
         * 
         * @param resourceIdOverrideConfiguration
         *        An optional structure that configures resource ID overrides to be applied within the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdOverrideConfiguration(
                AssetBundleImportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration);

        /**
         * <p>
         * An optional structure that configures resource ID overrides to be applied within the import job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportJobResourceIdOverrideConfiguration.Builder} avoiding the need to create one manually
         * via {@link AssetBundleImportJobResourceIdOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssetBundleImportJobResourceIdOverrideConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #resourceIdOverrideConfiguration(AssetBundleImportJobResourceIdOverrideConfiguration)}.
         * 
         * @param resourceIdOverrideConfiguration
         *        a consumer that will call methods on
         *        {@link AssetBundleImportJobResourceIdOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdOverrideConfiguration(AssetBundleImportJobResourceIdOverrideConfiguration)
         */
        default Builder resourceIdOverrideConfiguration(
                Consumer<AssetBundleImportJobResourceIdOverrideConfiguration.Builder> resourceIdOverrideConfiguration) {
            return resourceIdOverrideConfiguration(AssetBundleImportJobResourceIdOverrideConfiguration.builder()
                    .applyMutation(resourceIdOverrideConfiguration).build());
        }

        /**
         * <p>
         * A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param vpcConnections
         *        A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(Collection<AssetBundleImportJobVPCConnectionOverrideParameters> vpcConnections);

        /**
         * <p>
         * A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param vpcConnections
         *        A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(AssetBundleImportJobVPCConnectionOverrideParameters... vpcConnections);

        /**
         * <p>
         * A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vpcConnections(List<AssetBundleImportJobVPCConnectionOverrideParameters>)}.
         * 
         * @param vpcConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnections(java.util.Collection<AssetBundleImportJobVPCConnectionOverrideParameters>)
         */
        Builder vpcConnections(Consumer<AssetBundleImportJobVPCConnectionOverrideParameters.Builder>... vpcConnections);

        /**
         * <p>
         * A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * 
         * @param refreshSchedules
         *        A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(Collection<AssetBundleImportJobRefreshScheduleOverrideParameters> refreshSchedules);

        /**
         * <p>
         * A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * 
         * @param refreshSchedules
         *        A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(AssetBundleImportJobRefreshScheduleOverrideParameters... refreshSchedules);

        /**
         * <p>
         * A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #refreshSchedules(List<AssetBundleImportJobRefreshScheduleOverrideParameters>)}.
         * 
         * @param refreshSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedules(java.util.Collection<AssetBundleImportJobRefreshScheduleOverrideParameters>)
         */
        Builder refreshSchedules(Consumer<AssetBundleImportJobRefreshScheduleOverrideParameters.Builder>... refreshSchedules);

        /**
         * <p>
         * A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSources
         *        A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<AssetBundleImportJobDataSourceOverrideParameters> dataSources);

        /**
         * <p>
         * A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSources
         *        A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(AssetBundleImportJobDataSourceOverrideParameters... dataSources);

        /**
         * <p>
         * A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSources(List<AssetBundleImportJobDataSourceOverrideParameters>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<AssetBundleImportJobDataSourceOverrideParameters>)
         */
        Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverrideParameters.Builder>... dataSources);

        /**
         * <p>
         * A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSets
         *        A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<AssetBundleImportJobDataSetOverrideParameters> dataSets);

        /**
         * <p>
         * A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSets
         *        A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(AssetBundleImportJobDataSetOverrideParameters... dataSets);

        /**
         * <p>
         * A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSets(List<AssetBundleImportJobDataSetOverrideParameters>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<AssetBundleImportJobDataSetOverrideParameters>)
         */
        Builder dataSets(Consumer<AssetBundleImportJobDataSetOverrideParameters.Builder>... dataSets);

        /**
         * <p>
         * A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param themes
         *        A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(Collection<AssetBundleImportJobThemeOverrideParameters> themes);

        /**
         * <p>
         * A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param themes
         *        A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(AssetBundleImportJobThemeOverrideParameters... themes);

        /**
         * <p>
         * A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #themes(List<AssetBundleImportJobThemeOverrideParameters>)}.
         * 
         * @param themes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themes(java.util.Collection<AssetBundleImportJobThemeOverrideParameters>)
         */
        Builder themes(Consumer<AssetBundleImportJobThemeOverrideParameters.Builder>... themes);

        /**
         * <p>
         * A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param analyses
         *        A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(Collection<AssetBundleImportJobAnalysisOverrideParameters> analyses);

        /**
         * <p>
         * A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param analyses
         *        A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(AssetBundleImportJobAnalysisOverrideParameters... analyses);

        /**
         * <p>
         * A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #analyses(List<AssetBundleImportJobAnalysisOverrideParameters>)}.
         * 
         * @param analyses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyses(java.util.Collection<AssetBundleImportJobAnalysisOverrideParameters>)
         */
        Builder analyses(Consumer<AssetBundleImportJobAnalysisOverrideParameters.Builder>... analyses);

        /**
         * <p>
         * A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dashboards
         *        A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(Collection<AssetBundleImportJobDashboardOverrideParameters> dashboards);

        /**
         * <p>
         * A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dashboards
         *        A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(AssetBundleImportJobDashboardOverrideParameters... dashboards);

        /**
         * <p>
         * A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dashboards(List<AssetBundleImportJobDashboardOverrideParameters>)}.
         * 
         * @param dashboards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboards(java.util.Collection<AssetBundleImportJobDashboardOverrideParameters>)
         */
        Builder dashboards(Consumer<AssetBundleImportJobDashboardOverrideParameters.Builder>... dashboards);

        /**
         * <p>
         * A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param folders
         *        A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(Collection<AssetBundleImportJobFolderOverrideParameters> folders);

        /**
         * <p>
         * A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param folders
         *        A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(AssetBundleImportJobFolderOverrideParameters... folders);

        /**
         * <p>
         * A list of overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideParameters#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #folders(List<AssetBundleImportJobFolderOverrideParameters>)}.
         * 
         * @param folders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folders(java.util.Collection<AssetBundleImportJobFolderOverrideParameters>)
         */
        Builder folders(Consumer<AssetBundleImportJobFolderOverrideParameters.Builder>... folders);
    }

    static final class BuilderImpl implements Builder {
        private AssetBundleImportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration;

        private List<AssetBundleImportJobVPCConnectionOverrideParameters> vpcConnections = DefaultSdkAutoConstructList
                .getInstance();

        private List<AssetBundleImportJobRefreshScheduleOverrideParameters> refreshSchedules = DefaultSdkAutoConstructList
                .getInstance();

        private List<AssetBundleImportJobDataSourceOverrideParameters> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDataSetOverrideParameters> dataSets = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobThemeOverrideParameters> themes = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobAnalysisOverrideParameters> analyses = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDashboardOverrideParameters> dashboards = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobFolderOverrideParameters> folders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobOverrideParameters model) {
            resourceIdOverrideConfiguration(model.resourceIdOverrideConfiguration);
            vpcConnections(model.vpcConnections);
            refreshSchedules(model.refreshSchedules);
            dataSources(model.dataSources);
            dataSets(model.dataSets);
            themes(model.themes);
            analyses(model.analyses);
            dashboards(model.dashboards);
            folders(model.folders);
        }

        public final AssetBundleImportJobResourceIdOverrideConfiguration.Builder getResourceIdOverrideConfiguration() {
            return resourceIdOverrideConfiguration != null ? resourceIdOverrideConfiguration.toBuilder() : null;
        }

        public final void setResourceIdOverrideConfiguration(
                AssetBundleImportJobResourceIdOverrideConfiguration.BuilderImpl resourceIdOverrideConfiguration) {
            this.resourceIdOverrideConfiguration = resourceIdOverrideConfiguration != null ? resourceIdOverrideConfiguration
                    .build() : null;
        }

        @Override
        public final Builder resourceIdOverrideConfiguration(
                AssetBundleImportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration) {
            this.resourceIdOverrideConfiguration = resourceIdOverrideConfiguration;
            return this;
        }

        public final List<AssetBundleImportJobVPCConnectionOverrideParameters.Builder> getVpcConnections() {
            List<AssetBundleImportJobVPCConnectionOverrideParameters.Builder> result = AssetBundleImportJobVPCConnectionOverrideParametersListCopier
                    .copyToBuilder(this.vpcConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConnections(
                Collection<AssetBundleImportJobVPCConnectionOverrideParameters.BuilderImpl> vpcConnections) {
            this.vpcConnections = AssetBundleImportJobVPCConnectionOverrideParametersListCopier.copyFromBuilder(vpcConnections);
        }

        @Override
        public final Builder vpcConnections(Collection<AssetBundleImportJobVPCConnectionOverrideParameters> vpcConnections) {
            this.vpcConnections = AssetBundleImportJobVPCConnectionOverrideParametersListCopier.copy(vpcConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(AssetBundleImportJobVPCConnectionOverrideParameters... vpcConnections) {
            vpcConnections(Arrays.asList(vpcConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(
                Consumer<AssetBundleImportJobVPCConnectionOverrideParameters.Builder>... vpcConnections) {
            vpcConnections(Stream.of(vpcConnections)
                    .map(c -> AssetBundleImportJobVPCConnectionOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobRefreshScheduleOverrideParameters.Builder> getRefreshSchedules() {
            List<AssetBundleImportJobRefreshScheduleOverrideParameters.Builder> result = AssetBundleImportJobRefreshScheduleOverrideParametersListCopier
                    .copyToBuilder(this.refreshSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRefreshSchedules(
                Collection<AssetBundleImportJobRefreshScheduleOverrideParameters.BuilderImpl> refreshSchedules) {
            this.refreshSchedules = AssetBundleImportJobRefreshScheduleOverrideParametersListCopier
                    .copyFromBuilder(refreshSchedules);
        }

        @Override
        public final Builder refreshSchedules(Collection<AssetBundleImportJobRefreshScheduleOverrideParameters> refreshSchedules) {
            this.refreshSchedules = AssetBundleImportJobRefreshScheduleOverrideParametersListCopier.copy(refreshSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(AssetBundleImportJobRefreshScheduleOverrideParameters... refreshSchedules) {
            refreshSchedules(Arrays.asList(refreshSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(
                Consumer<AssetBundleImportJobRefreshScheduleOverrideParameters.Builder>... refreshSchedules) {
            refreshSchedules(Stream.of(refreshSchedules)
                    .map(c -> AssetBundleImportJobRefreshScheduleOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDataSourceOverrideParameters.Builder> getDataSources() {
            List<AssetBundleImportJobDataSourceOverrideParameters.Builder> result = AssetBundleImportJobDataSourceOverrideParametersListCopier
                    .copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<AssetBundleImportJobDataSourceOverrideParameters.BuilderImpl> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverrideParametersListCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<AssetBundleImportJobDataSourceOverrideParameters> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverrideParametersListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(AssetBundleImportJobDataSourceOverrideParameters... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverrideParameters.Builder>... dataSources) {
            dataSources(Stream.of(dataSources)
                    .map(c -> AssetBundleImportJobDataSourceOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDataSetOverrideParameters.Builder> getDataSets() {
            List<AssetBundleImportJobDataSetOverrideParameters.Builder> result = AssetBundleImportJobDataSetOverrideParametersListCopier
                    .copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<AssetBundleImportJobDataSetOverrideParameters.BuilderImpl> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverrideParametersListCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<AssetBundleImportJobDataSetOverrideParameters> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverrideParametersListCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(AssetBundleImportJobDataSetOverrideParameters... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<AssetBundleImportJobDataSetOverrideParameters.Builder>... dataSets) {
            dataSets(Stream.of(dataSets)
                    .map(c -> AssetBundleImportJobDataSetOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobThemeOverrideParameters.Builder> getThemes() {
            List<AssetBundleImportJobThemeOverrideParameters.Builder> result = AssetBundleImportJobThemeOverrideParametersListCopier
                    .copyToBuilder(this.themes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemes(Collection<AssetBundleImportJobThemeOverrideParameters.BuilderImpl> themes) {
            this.themes = AssetBundleImportJobThemeOverrideParametersListCopier.copyFromBuilder(themes);
        }

        @Override
        public final Builder themes(Collection<AssetBundleImportJobThemeOverrideParameters> themes) {
            this.themes = AssetBundleImportJobThemeOverrideParametersListCopier.copy(themes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(AssetBundleImportJobThemeOverrideParameters... themes) {
            themes(Arrays.asList(themes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(Consumer<AssetBundleImportJobThemeOverrideParameters.Builder>... themes) {
            themes(Stream.of(themes).map(c -> AssetBundleImportJobThemeOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobAnalysisOverrideParameters.Builder> getAnalyses() {
            List<AssetBundleImportJobAnalysisOverrideParameters.Builder> result = AssetBundleImportJobAnalysisOverrideParametersListCopier
                    .copyToBuilder(this.analyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyses(Collection<AssetBundleImportJobAnalysisOverrideParameters.BuilderImpl> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverrideParametersListCopier.copyFromBuilder(analyses);
        }

        @Override
        public final Builder analyses(Collection<AssetBundleImportJobAnalysisOverrideParameters> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverrideParametersListCopier.copy(analyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(AssetBundleImportJobAnalysisOverrideParameters... analyses) {
            analyses(Arrays.asList(analyses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(Consumer<AssetBundleImportJobAnalysisOverrideParameters.Builder>... analyses) {
            analyses(Stream.of(analyses)
                    .map(c -> AssetBundleImportJobAnalysisOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDashboardOverrideParameters.Builder> getDashboards() {
            List<AssetBundleImportJobDashboardOverrideParameters.Builder> result = AssetBundleImportJobDashboardOverrideParametersListCopier
                    .copyToBuilder(this.dashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboards(Collection<AssetBundleImportJobDashboardOverrideParameters.BuilderImpl> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverrideParametersListCopier.copyFromBuilder(dashboards);
        }

        @Override
        public final Builder dashboards(Collection<AssetBundleImportJobDashboardOverrideParameters> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverrideParametersListCopier.copy(dashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(AssetBundleImportJobDashboardOverrideParameters... dashboards) {
            dashboards(Arrays.asList(dashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(Consumer<AssetBundleImportJobDashboardOverrideParameters.Builder>... dashboards) {
            dashboards(Stream.of(dashboards)
                    .map(c -> AssetBundleImportJobDashboardOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobFolderOverrideParameters.Builder> getFolders() {
            List<AssetBundleImportJobFolderOverrideParameters.Builder> result = AssetBundleImportJobFolderOverrideParametersListCopier
                    .copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolders(Collection<AssetBundleImportJobFolderOverrideParameters.BuilderImpl> folders) {
            this.folders = AssetBundleImportJobFolderOverrideParametersListCopier.copyFromBuilder(folders);
        }

        @Override
        public final Builder folders(Collection<AssetBundleImportJobFolderOverrideParameters> folders) {
            this.folders = AssetBundleImportJobFolderOverrideParametersListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(AssetBundleImportJobFolderOverrideParameters... folders) {
            folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<AssetBundleImportJobFolderOverrideParameters.Builder>... folders) {
            folders(Stream.of(folders).map(c -> AssetBundleImportJobFolderOverrideParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetBundleImportJobOverrideParameters build() {
            return new AssetBundleImportJobOverrideParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
