/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of an <code>AggregationPartitionBy</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationPartitionBy implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationPartitionBy.Builder, AggregationPartitionBy> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(AggregationPartitionBy::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(AggregationPartitionBy::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            TIME_GRANULARITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String timeGranularity;

    private AggregationPartitionBy(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.timeGranularity = builder.timeGranularity;
    }

    /**
     * <p>
     * The field Name for an <code>AggregationPartitionBy</code>.
     * </p>
     * 
     * @return The field Name for an <code>AggregationPartitionBy</code>.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationPartitionBy)) {
            return false;
        }
        AggregationPartitionBy other = (AggregationPartitionBy) obj;
        return Objects.equals(fieldName(), other.fieldName())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationPartitionBy").add("FieldName", fieldName())
                .add("TimeGranularity", timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationPartitionBy, T> g) {
        return obj -> g.apply((AggregationPartitionBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationPartitionBy> {
        /**
         * <p>
         * The field Name for an <code>AggregationPartitionBy</code>.
         * </p>
         * 
         * @param fieldName
         *        The field Name for an <code>AggregationPartitionBy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationPartitionBy model) {
            fieldName(model.fieldName);
            timeGranularity(model.timeGranularity);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        @Override
        public AggregationPartitionBy build() {
            return new AggregationPartitionBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
