/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.UniqueKey;
import software.amazon.awssdk.services.quicksight.model.UniqueKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceConfiguration> {
    private static final SdkField<List<UniqueKey>> UNIQUE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UniqueKeys").getter(PerformanceConfiguration.getter(PerformanceConfiguration::uniqueKeys)).setter(PerformanceConfiguration.setter(Builder::uniqueKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UniqueKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIQUE_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PerformanceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<UniqueKey> uniqueKeys;

    private PerformanceConfiguration(BuilderImpl builder) {
        this.uniqueKeys = builder.uniqueKeys;
    }

    public final boolean hasUniqueKeys() {
        return this.uniqueKeys != null && !(this.uniqueKeys instanceof SdkAutoConstructList);
    }

    public final List<UniqueKey> uniqueKeys() {
        return this.uniqueKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUniqueKeys() ? this.uniqueKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceConfiguration)) {
            return false;
        }
        PerformanceConfiguration other = (PerformanceConfiguration)obj;
        return this.hasUniqueKeys() == other.hasUniqueKeys() && Objects.equals(this.uniqueKeys(), other.uniqueKeys());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceConfiguration").add("UniqueKeys", this.hasUniqueKeys() ? this.uniqueKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UniqueKeys": {
                return Optional.ofNullable(clazz.cast(this.uniqueKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<UniqueKey>>> map = new HashMap<String, SdkField<List<UniqueKey>>>();
        map.put("UniqueKeys", UNIQUE_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceConfiguration, T> g) {
        return obj -> g.apply((PerformanceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UniqueKey> uniqueKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceConfiguration model) {
            this.uniqueKeys(model.uniqueKeys);
        }

        public final List<UniqueKey.Builder> getUniqueKeys() {
            List<UniqueKey.Builder> result = UniqueKeyListCopier.copyToBuilder(this.uniqueKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUniqueKeys(Collection<UniqueKey.BuilderImpl> uniqueKeys) {
            this.uniqueKeys = UniqueKeyListCopier.copyFromBuilder(uniqueKeys);
        }

        @Override
        public final Builder uniqueKeys(Collection<UniqueKey> uniqueKeys) {
            this.uniqueKeys = UniqueKeyListCopier.copy(uniqueKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(UniqueKey ... uniqueKeys) {
            this.uniqueKeys(Arrays.asList(uniqueKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(Consumer<UniqueKey.Builder> ... uniqueKeys) {
            this.uniqueKeys(Stream.of(uniqueKeys).map(c -> (UniqueKey)((UniqueKey.Builder)UniqueKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PerformanceConfiguration build() {
            return new PerformanceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceConfiguration> {
        public Builder uniqueKeys(Collection<UniqueKey> var1);

        public Builder uniqueKeys(UniqueKey ... var1);

        public Builder uniqueKeys(Consumer<UniqueKey.Builder> ... var1);
    }
}

