/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RelativeFontSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FontSize
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FontSize> {
    private static final SdkField<String> RELATIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Relative").getter(FontSize.getter(FontSize::relativeAsString)).setter(FontSize.setter(Builder::relative)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relative").build()}).build();
    private static final SdkField<String> ABSOLUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Absolute").getter(FontSize.getter(FontSize::absolute)).setter(FontSize.setter(Builder::absolute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Absolute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIVE_FIELD, ABSOLUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FontSize.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String relative;
    private final String absolute;

    private FontSize(BuilderImpl builder) {
        this.relative = builder.relative;
        this.absolute = builder.absolute;
    }

    public final RelativeFontSize relative() {
        return RelativeFontSize.fromValue(this.relative);
    }

    public final String relativeAsString() {
        return this.relative;
    }

    public final String absolute() {
        return this.absolute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.absolute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontSize)) {
            return false;
        }
        FontSize other = (FontSize)obj;
        return Objects.equals(this.relativeAsString(), other.relativeAsString()) && Objects.equals(this.absolute(), other.absolute());
    }

    public final String toString() {
        return ToString.builder((String)"FontSize").add("Relative", (Object)this.relativeAsString()).add("Absolute", (Object)this.absolute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Relative": {
                return Optional.ofNullable(clazz.cast(this.relativeAsString()));
            }
            case "Absolute": {
                return Optional.ofNullable(clazz.cast(this.absolute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Relative", RELATIVE_FIELD);
        map.put("Absolute", ABSOLUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FontSize, T> g) {
        return obj -> g.apply((FontSize)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relative;
        private String absolute;

        private BuilderImpl() {
        }

        private BuilderImpl(FontSize model) {
            this.relative(model.relative);
            this.absolute(model.absolute);
        }

        public final String getRelative() {
            return this.relative;
        }

        public final void setRelative(String relative) {
            this.relative = relative;
        }

        @Override
        public final Builder relative(String relative) {
            this.relative = relative;
            return this;
        }

        @Override
        public final Builder relative(RelativeFontSize relative) {
            this.relative(relative == null ? null : relative.toString());
            return this;
        }

        public final String getAbsolute() {
            return this.absolute;
        }

        public final void setAbsolute(String absolute) {
            this.absolute = absolute;
        }

        @Override
        public final Builder absolute(String absolute) {
            this.absolute = absolute;
            return this;
        }

        public FontSize build() {
            return new FontSize(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FontSize> {
        public Builder relative(String var1);

        public Builder relative(RelativeFontSize var1);

        public Builder absolute(String var1);
    }
}

