/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DateTimeDefaultValueListCopier;
import software.amazon.awssdk.services.quicksight.model.DynamicDefaultValue;
import software.amazon.awssdk.services.quicksight.model.RollingDateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeDefaultValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeDefaultValues> {
    private static final SdkField<DynamicDefaultValue> DYNAMIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicValue").getter(DateTimeDefaultValues.getter(DateTimeDefaultValues::dynamicValue)).setter(DateTimeDefaultValues.setter(Builder::dynamicValue)).constructor(DynamicDefaultValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicValue").build()}).build();
    private static final SdkField<List<Instant>> STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaticValues").getter(DateTimeDefaultValues.getter(DateTimeDefaultValues::staticValues)).setter(DateTimeDefaultValues.setter(Builder::staticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RollingDateConfiguration> ROLLING_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollingDate").getter(DateTimeDefaultValues.getter(DateTimeDefaultValues::rollingDate)).setter(DateTimeDefaultValues.setter(Builder::rollingDate)).constructor(RollingDateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_VALUE_FIELD, STATIC_VALUES_FIELD, ROLLING_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DateTimeDefaultValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DynamicDefaultValue dynamicValue;
    private final List<Instant> staticValues;
    private final RollingDateConfiguration rollingDate;

    private DateTimeDefaultValues(BuilderImpl builder) {
        this.dynamicValue = builder.dynamicValue;
        this.staticValues = builder.staticValues;
        this.rollingDate = builder.rollingDate;
    }

    public final DynamicDefaultValue dynamicValue() {
        return this.dynamicValue;
    }

    public final boolean hasStaticValues() {
        return this.staticValues != null && !(this.staticValues instanceof SdkAutoConstructList);
    }

    public final List<Instant> staticValues() {
        return this.staticValues;
    }

    public final RollingDateConfiguration rollingDate() {
        return this.rollingDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticValues() ? this.staticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeDefaultValues)) {
            return false;
        }
        DateTimeDefaultValues other = (DateTimeDefaultValues)obj;
        return Objects.equals(this.dynamicValue(), other.dynamicValue()) && this.hasStaticValues() == other.hasStaticValues() && Objects.equals(this.staticValues(), other.staticValues()) && Objects.equals(this.rollingDate(), other.rollingDate());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeDefaultValues").add("DynamicValue", (Object)this.dynamicValue()).add("StaticValues", (Object)(this.staticValues() == null ? null : "*** Sensitive Data Redacted ***")).add("RollingDate", (Object)this.rollingDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DynamicValue": {
                return Optional.ofNullable(clazz.cast(this.dynamicValue()));
            }
            case "StaticValues": {
                return Optional.ofNullable(clazz.cast(this.staticValues()));
            }
            case "RollingDate": {
                return Optional.ofNullable(clazz.cast(this.rollingDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DynamicValue", DYNAMIC_VALUE_FIELD);
        map.put("StaticValues", STATIC_VALUES_FIELD);
        map.put("RollingDate", ROLLING_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimeDefaultValues, T> g) {
        return obj -> g.apply((DateTimeDefaultValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DynamicDefaultValue dynamicValue;
        private List<Instant> staticValues = DefaultSdkAutoConstructList.getInstance();
        private RollingDateConfiguration rollingDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeDefaultValues model) {
            this.dynamicValue(model.dynamicValue);
            this.staticValues(model.staticValues);
            this.rollingDate(model.rollingDate);
        }

        public final DynamicDefaultValue.Builder getDynamicValue() {
            return this.dynamicValue != null ? this.dynamicValue.toBuilder() : null;
        }

        public final void setDynamicValue(DynamicDefaultValue.BuilderImpl dynamicValue) {
            this.dynamicValue = dynamicValue != null ? dynamicValue.build() : null;
        }

        @Override
        public final Builder dynamicValue(DynamicDefaultValue dynamicValue) {
            this.dynamicValue = dynamicValue;
            return this;
        }

        public final Collection<Instant> getStaticValues() {
            if (this.staticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.staticValues;
        }

        public final void setStaticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDefaultValueListCopier.copy(staticValues);
        }

        @Override
        public final Builder staticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDefaultValueListCopier.copy(staticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticValues(Instant ... staticValues) {
            this.staticValues(Arrays.asList(staticValues));
            return this;
        }

        public final RollingDateConfiguration.Builder getRollingDate() {
            return this.rollingDate != null ? this.rollingDate.toBuilder() : null;
        }

        public final void setRollingDate(RollingDateConfiguration.BuilderImpl rollingDate) {
            this.rollingDate = rollingDate != null ? rollingDate.build() : null;
        }

        @Override
        public final Builder rollingDate(RollingDateConfiguration rollingDate) {
            this.rollingDate = rollingDate;
            return this;
        }

        public DateTimeDefaultValues build() {
            return new DateTimeDefaultValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeDefaultValues> {
        public Builder dynamicValue(DynamicDefaultValue var1);

        default public Builder dynamicValue(Consumer<DynamicDefaultValue.Builder> dynamicValue) {
            return this.dynamicValue((DynamicDefaultValue)((DynamicDefaultValue.Builder)DynamicDefaultValue.builder().applyMutation(dynamicValue)).build());
        }

        public Builder staticValues(Collection<Instant> var1);

        public Builder staticValues(Instant ... var1);

        public Builder rollingDate(RollingDateConfiguration var1);

        default public Builder rollingDate(Consumer<RollingDateConfiguration.Builder> rollingDate) {
            return this.rollingDate((RollingDateConfiguration)((RollingDateConfiguration.Builder)RollingDateConfiguration.builder().applyMutation(rollingDate)).build());
        }
    }
}

