/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataLabelContent;
import software.amazon.awssdk.services.quicksight.model.DataLabelOverlap;
import software.amazon.awssdk.services.quicksight.model.DataLabelPosition;
import software.amazon.awssdk.services.quicksight.model.DataLabelType;
import software.amazon.awssdk.services.quicksight.model.DataLabelTypesCopier;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(DataLabelOptions.getter(DataLabelOptions::visibilityAsString)).setter(DataLabelOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> CATEGORY_LABEL_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryLabelVisibility").getter(DataLabelOptions.getter(DataLabelOptions::categoryLabelVisibilityAsString)).setter(DataLabelOptions.setter(Builder::categoryLabelVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelVisibility").build()}).build();
    private static final SdkField<String> MEASURE_LABEL_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureLabelVisibility").getter(DataLabelOptions.getter(DataLabelOptions::measureLabelVisibilityAsString)).setter(DataLabelOptions.setter(Builder::measureLabelVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureLabelVisibility").build()}).build();
    private static final SdkField<List<DataLabelType>> DATA_LABEL_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataLabelTypes").getter(DataLabelOptions.getter(DataLabelOptions::dataLabelTypes)).setter(DataLabelOptions.setter(Builder::dataLabelTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabelTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLabelType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Position").getter(DataLabelOptions.getter(DataLabelOptions::positionAsString)).setter(DataLabelOptions.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()}).build();
    private static final SdkField<String> LABEL_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelContent").getter(DataLabelOptions.getter(DataLabelOptions::labelContentAsString)).setter(DataLabelOptions.setter(Builder::labelContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelContent").build()}).build();
    private static final SdkField<FontConfiguration> LABEL_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelFontConfiguration").getter(DataLabelOptions.getter(DataLabelOptions::labelFontConfiguration)).setter(DataLabelOptions.setter(Builder::labelFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelFontConfiguration").build()}).build();
    private static final SdkField<String> LABEL_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelColor").getter(DataLabelOptions.getter(DataLabelOptions::labelColor)).setter(DataLabelOptions.setter(Builder::labelColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColor").build()}).build();
    private static final SdkField<String> OVERLAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Overlap").getter(DataLabelOptions.getter(DataLabelOptions::overlapAsString)).setter(DataLabelOptions.setter(Builder::overlap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overlap").build()}).build();
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalsVisibility").getter(DataLabelOptions.getter(DataLabelOptions::totalsVisibilityAsString)).setter(DataLabelOptions.setter(Builder::totalsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, CATEGORY_LABEL_VISIBILITY_FIELD, MEASURE_LABEL_VISIBILITY_FIELD, DATA_LABEL_TYPES_FIELD, POSITION_FIELD, LABEL_CONTENT_FIELD, LABEL_FONT_CONFIGURATION_FIELD, LABEL_COLOR_FIELD, OVERLAP_FIELD, TOTALS_VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLabelOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final String categoryLabelVisibility;
    private final String measureLabelVisibility;
    private final List<DataLabelType> dataLabelTypes;
    private final String position;
    private final String labelContent;
    private final FontConfiguration labelFontConfiguration;
    private final String labelColor;
    private final String overlap;
    private final String totalsVisibility;

    private DataLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.categoryLabelVisibility = builder.categoryLabelVisibility;
        this.measureLabelVisibility = builder.measureLabelVisibility;
        this.dataLabelTypes = builder.dataLabelTypes;
        this.position = builder.position;
        this.labelContent = builder.labelContent;
        this.labelFontConfiguration = builder.labelFontConfiguration;
        this.labelColor = builder.labelColor;
        this.overlap = builder.overlap;
        this.totalsVisibility = builder.totalsVisibility;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Visibility categoryLabelVisibility() {
        return Visibility.fromValue(this.categoryLabelVisibility);
    }

    public final String categoryLabelVisibilityAsString() {
        return this.categoryLabelVisibility;
    }

    public final Visibility measureLabelVisibility() {
        return Visibility.fromValue(this.measureLabelVisibility);
    }

    public final String measureLabelVisibilityAsString() {
        return this.measureLabelVisibility;
    }

    public final boolean hasDataLabelTypes() {
        return this.dataLabelTypes != null && !(this.dataLabelTypes instanceof SdkAutoConstructList);
    }

    public final List<DataLabelType> dataLabelTypes() {
        return this.dataLabelTypes;
    }

    public final DataLabelPosition position() {
        return DataLabelPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public final DataLabelContent labelContent() {
        return DataLabelContent.fromValue(this.labelContent);
    }

    public final String labelContentAsString() {
        return this.labelContent;
    }

    public final FontConfiguration labelFontConfiguration() {
        return this.labelFontConfiguration;
    }

    public final String labelColor() {
        return this.labelColor;
    }

    public final DataLabelOverlap overlap() {
        return DataLabelOverlap.fromValue(this.overlap);
    }

    public final String overlapAsString() {
        return this.overlap;
    }

    public final Visibility totalsVisibility() {
        return Visibility.fromValue(this.totalsVisibility);
    }

    public final String totalsVisibilityAsString() {
        return this.totalsVisibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataLabelTypes() ? this.dataLabelTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelContentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.overlapAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalsVisibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLabelOptions)) {
            return false;
        }
        DataLabelOptions other = (DataLabelOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.categoryLabelVisibilityAsString(), other.categoryLabelVisibilityAsString()) && Objects.equals(this.measureLabelVisibilityAsString(), other.measureLabelVisibilityAsString()) && this.hasDataLabelTypes() == other.hasDataLabelTypes() && Objects.equals(this.dataLabelTypes(), other.dataLabelTypes()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.labelContentAsString(), other.labelContentAsString()) && Objects.equals(this.labelFontConfiguration(), other.labelFontConfiguration()) && Objects.equals(this.labelColor(), other.labelColor()) && Objects.equals(this.overlapAsString(), other.overlapAsString()) && Objects.equals(this.totalsVisibilityAsString(), other.totalsVisibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataLabelOptions").add("Visibility", (Object)this.visibilityAsString()).add("CategoryLabelVisibility", (Object)this.categoryLabelVisibilityAsString()).add("MeasureLabelVisibility", (Object)this.measureLabelVisibilityAsString()).add("DataLabelTypes", this.hasDataLabelTypes() ? this.dataLabelTypes() : null).add("Position", (Object)this.positionAsString()).add("LabelContent", (Object)this.labelContentAsString()).add("LabelFontConfiguration", (Object)this.labelFontConfiguration()).add("LabelColor", (Object)this.labelColor()).add("Overlap", (Object)this.overlapAsString()).add("TotalsVisibility", (Object)this.totalsVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "CategoryLabelVisibility": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelVisibilityAsString()));
            }
            case "MeasureLabelVisibility": {
                return Optional.ofNullable(clazz.cast(this.measureLabelVisibilityAsString()));
            }
            case "DataLabelTypes": {
                return Optional.ofNullable(clazz.cast(this.dataLabelTypes()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "LabelContent": {
                return Optional.ofNullable(clazz.cast(this.labelContentAsString()));
            }
            case "LabelFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelFontConfiguration()));
            }
            case "LabelColor": {
                return Optional.ofNullable(clazz.cast(this.labelColor()));
            }
            case "Overlap": {
                return Optional.ofNullable(clazz.cast(this.overlapAsString()));
            }
            case "TotalsVisibility": {
                return Optional.ofNullable(clazz.cast(this.totalsVisibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("CategoryLabelVisibility", CATEGORY_LABEL_VISIBILITY_FIELD);
        map.put("MeasureLabelVisibility", MEASURE_LABEL_VISIBILITY_FIELD);
        map.put("DataLabelTypes", DATA_LABEL_TYPES_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("LabelContent", LABEL_CONTENT_FIELD);
        map.put("LabelFontConfiguration", LABEL_FONT_CONFIGURATION_FIELD);
        map.put("LabelColor", LABEL_COLOR_FIELD);
        map.put("Overlap", OVERLAP_FIELD);
        map.put("TotalsVisibility", TOTALS_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLabelOptions, T> g) {
        return obj -> g.apply((DataLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private String categoryLabelVisibility;
        private String measureLabelVisibility;
        private List<DataLabelType> dataLabelTypes = DefaultSdkAutoConstructList.getInstance();
        private String position;
        private String labelContent;
        private FontConfiguration labelFontConfiguration;
        private String labelColor;
        private String overlap;
        private String totalsVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLabelOptions model) {
            this.visibility(model.visibility);
            this.categoryLabelVisibility(model.categoryLabelVisibility);
            this.measureLabelVisibility(model.measureLabelVisibility);
            this.dataLabelTypes(model.dataLabelTypes);
            this.position(model.position);
            this.labelContent(model.labelContent);
            this.labelFontConfiguration(model.labelFontConfiguration);
            this.labelColor(model.labelColor);
            this.overlap(model.overlap);
            this.totalsVisibility(model.totalsVisibility);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getCategoryLabelVisibility() {
            return this.categoryLabelVisibility;
        }

        public final void setCategoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
        }

        @Override
        public final Builder categoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
            return this;
        }

        @Override
        public final Builder categoryLabelVisibility(Visibility categoryLabelVisibility) {
            this.categoryLabelVisibility(categoryLabelVisibility == null ? null : categoryLabelVisibility.toString());
            return this;
        }

        public final String getMeasureLabelVisibility() {
            return this.measureLabelVisibility;
        }

        public final void setMeasureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
        }

        @Override
        public final Builder measureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
            return this;
        }

        @Override
        public final Builder measureLabelVisibility(Visibility measureLabelVisibility) {
            this.measureLabelVisibility(measureLabelVisibility == null ? null : measureLabelVisibility.toString());
            return this;
        }

        public final List<DataLabelType.Builder> getDataLabelTypes() {
            List<DataLabelType.Builder> result = DataLabelTypesCopier.copyToBuilder(this.dataLabelTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLabelTypes(Collection<DataLabelType.BuilderImpl> dataLabelTypes) {
            this.dataLabelTypes = DataLabelTypesCopier.copyFromBuilder(dataLabelTypes);
        }

        @Override
        public final Builder dataLabelTypes(Collection<DataLabelType> dataLabelTypes) {
            this.dataLabelTypes = DataLabelTypesCopier.copy(dataLabelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLabelTypes(DataLabelType ... dataLabelTypes) {
            this.dataLabelTypes(Arrays.asList(dataLabelTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLabelTypes(Consumer<DataLabelType.Builder> ... dataLabelTypes) {
            this.dataLabelTypes(Stream.of(dataLabelTypes).map(c -> (DataLabelType)((DataLabelType.Builder)DataLabelType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(DataLabelPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getLabelContent() {
            return this.labelContent;
        }

        public final void setLabelContent(String labelContent) {
            this.labelContent = labelContent;
        }

        @Override
        public final Builder labelContent(String labelContent) {
            this.labelContent = labelContent;
            return this;
        }

        @Override
        public final Builder labelContent(DataLabelContent labelContent) {
            this.labelContent(labelContent == null ? null : labelContent.toString());
            return this;
        }

        public final FontConfiguration.Builder getLabelFontConfiguration() {
            return this.labelFontConfiguration != null ? this.labelFontConfiguration.toBuilder() : null;
        }

        public final void setLabelFontConfiguration(FontConfiguration.BuilderImpl labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration != null ? labelFontConfiguration.build() : null;
        }

        @Override
        public final Builder labelFontConfiguration(FontConfiguration labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration;
            return this;
        }

        public final String getLabelColor() {
            return this.labelColor;
        }

        public final void setLabelColor(String labelColor) {
            this.labelColor = labelColor;
        }

        @Override
        public final Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public final String getOverlap() {
            return this.overlap;
        }

        public final void setOverlap(String overlap) {
            this.overlap = overlap;
        }

        @Override
        public final Builder overlap(String overlap) {
            this.overlap = overlap;
            return this;
        }

        @Override
        public final Builder overlap(DataLabelOverlap overlap) {
            this.overlap(overlap == null ? null : overlap.toString());
            return this;
        }

        public final String getTotalsVisibility() {
            return this.totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public DataLabelOptions build() {
            return new DataLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLabelOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder categoryLabelVisibility(String var1);

        public Builder categoryLabelVisibility(Visibility var1);

        public Builder measureLabelVisibility(String var1);

        public Builder measureLabelVisibility(Visibility var1);

        public Builder dataLabelTypes(Collection<DataLabelType> var1);

        public Builder dataLabelTypes(DataLabelType ... var1);

        public Builder dataLabelTypes(Consumer<DataLabelType.Builder> ... var1);

        public Builder position(String var1);

        public Builder position(DataLabelPosition var1);

        public Builder labelContent(String var1);

        public Builder labelContent(DataLabelContent var1);

        public Builder labelFontConfiguration(FontConfiguration var1);

        default public Builder labelFontConfiguration(Consumer<FontConfiguration.Builder> labelFontConfiguration) {
            return this.labelFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(labelFontConfiguration)).build());
        }

        public Builder labelColor(String var1);

        public Builder overlap(String var1);

        public Builder overlap(DataLabelOverlap var1);

        public Builder totalsVisibility(String var1);

        public Builder totalsVisibility(Visibility var1);
    }
}

