/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrandStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_SUCCEEDED("CREATE_SUCCEEDED"),
    CREATE_FAILED("CREATE_FAILED"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrandStatus> VALUE_MAP;
    private final String value;

    private BrandStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrandStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrandStatus> knownValues() {
        EnumSet<BrandStatus> knownValues = EnumSet.allOf(BrandStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrandStatus.class, BrandStatus::toString);
    }
}

