/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FolderType {
    SHARED("SHARED"),
    RESTRICTED("RESTRICTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FolderType> VALUE_MAP;
    private final String value;

    private FolderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FolderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FolderType> knownValues() {
        EnumSet<FolderType> knownValues = EnumSet.allOf(FolderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FolderType.class, FolderType::toString);
    }
}

