/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggType;
import software.amazon.awssdk.services.quicksight.model.Identifier;
import software.amazon.awssdk.services.quicksight.model.TopicSortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterAggMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterAggMetrics> {
    private static final SdkField<Identifier> METRIC_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricOperand").getter(FilterAggMetrics.getter(FilterAggMetrics::metricOperand)).setter(FilterAggMetrics.setter(Builder::metricOperand)).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricOperand").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Function").getter(FilterAggMetrics.getter(FilterAggMetrics::functionAsString)).setter(FilterAggMetrics.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortDirection").getter(FilterAggMetrics.getter(FilterAggMetrics::sortDirectionAsString)).setter(FilterAggMetrics.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_OPERAND_FIELD, FUNCTION_FIELD, SORT_DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterAggMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Identifier metricOperand;
    private final String function;
    private final String sortDirection;

    private FilterAggMetrics(BuilderImpl builder) {
        this.metricOperand = builder.metricOperand;
        this.function = builder.function;
        this.sortDirection = builder.sortDirection;
    }

    public final Identifier metricOperand() {
        return this.metricOperand;
    }

    public final AggType function() {
        return AggType.fromValue(this.function);
    }

    public final String functionAsString() {
        return this.function;
    }

    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterAggMetrics)) {
            return false;
        }
        FilterAggMetrics other = (FilterAggMetrics)obj;
        return Objects.equals(this.metricOperand(), other.metricOperand()) && Objects.equals(this.functionAsString(), other.functionAsString()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FilterAggMetrics").add("MetricOperand", (Object)this.metricOperand()).add("Function", (Object)this.functionAsString()).add("SortDirection", (Object)this.sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricOperand": {
                return Optional.ofNullable(clazz.cast(this.metricOperand()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.functionAsString()));
            }
            case "SortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricOperand", METRIC_OPERAND_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("SortDirection", SORT_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterAggMetrics, T> g) {
        return obj -> g.apply((FilterAggMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identifier metricOperand;
        private String function;
        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterAggMetrics model) {
            this.metricOperand(model.metricOperand);
            this.function(model.function);
            this.sortDirection(model.sortDirection);
        }

        public final Identifier.Builder getMetricOperand() {
            return this.metricOperand != null ? this.metricOperand.toBuilder() : null;
        }

        public final void setMetricOperand(Identifier.BuilderImpl metricOperand) {
            this.metricOperand = metricOperand != null ? metricOperand.build() : null;
        }

        @Override
        public final Builder metricOperand(Identifier metricOperand) {
            this.metricOperand = metricOperand;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(AggType function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public FilterAggMetrics build() {
            return new FilterAggMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterAggMetrics> {
        public Builder metricOperand(Identifier var1);

        default public Builder metricOperand(Consumer<Identifier.Builder> metricOperand) {
            return this.metricOperand((Identifier)((Identifier.Builder)Identifier.builder().applyMutation(metricOperand)).build());
        }

        public Builder function(String var1);

        public Builder function(AggType var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(TopicSortDirection var1);
    }
}

