/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ApplicationTheme;
import software.amazon.awssdk.services.quicksight.model.LogoConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrandDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrandDefinition> {
    private static final SdkField<String> BRAND_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandName").getter(BrandDefinition.getter(BrandDefinition::brandName)).setter(BrandDefinition.setter(Builder::brandName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(BrandDefinition.getter(BrandDefinition::description)).setter(BrandDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ApplicationTheme> APPLICATION_THEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationTheme").getter(BrandDefinition.getter(BrandDefinition::applicationTheme)).setter(BrandDefinition.setter(Builder::applicationTheme)).constructor(ApplicationTheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTheme").build()}).build();
    private static final SdkField<LogoConfiguration> LOGO_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogoConfiguration").getter(BrandDefinition.getter(BrandDefinition::logoConfiguration)).setter(BrandDefinition.setter(Builder::logoConfiguration)).constructor(LogoConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_NAME_FIELD, DESCRIPTION_FIELD, APPLICATION_THEME_FIELD, LOGO_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrandDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String brandName;
    private final String description;
    private final ApplicationTheme applicationTheme;
    private final LogoConfiguration logoConfiguration;

    private BrandDefinition(BuilderImpl builder) {
        this.brandName = builder.brandName;
        this.description = builder.description;
        this.applicationTheme = builder.applicationTheme;
        this.logoConfiguration = builder.logoConfiguration;
    }

    public final String brandName() {
        return this.brandName;
    }

    public final String description() {
        return this.description;
    }

    public final ApplicationTheme applicationTheme() {
        return this.applicationTheme;
    }

    public final LogoConfiguration logoConfiguration() {
        return this.logoConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brandName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandDefinition)) {
            return false;
        }
        BrandDefinition other = (BrandDefinition)obj;
        return Objects.equals(this.brandName(), other.brandName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.applicationTheme(), other.applicationTheme()) && Objects.equals(this.logoConfiguration(), other.logoConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BrandDefinition").add("BrandName", (Object)this.brandName()).add("Description", (Object)this.description()).add("ApplicationTheme", (Object)this.applicationTheme()).add("LogoConfiguration", (Object)this.logoConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrandName": {
                return Optional.ofNullable(clazz.cast(this.brandName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApplicationTheme": {
                return Optional.ofNullable(clazz.cast(this.applicationTheme()));
            }
            case "LogoConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logoConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BrandName", BRAND_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationTheme", APPLICATION_THEME_FIELD);
        map.put("LogoConfiguration", LOGO_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandDefinition, T> g) {
        return obj -> g.apply((BrandDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String brandName;
        private String description;
        private ApplicationTheme applicationTheme;
        private LogoConfiguration logoConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandDefinition model) {
            this.brandName(model.brandName);
            this.description(model.description);
            this.applicationTheme(model.applicationTheme);
            this.logoConfiguration(model.logoConfiguration);
        }

        public final String getBrandName() {
            return this.brandName;
        }

        public final void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        @Override
        public final Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationTheme.Builder getApplicationTheme() {
            return this.applicationTheme != null ? this.applicationTheme.toBuilder() : null;
        }

        public final void setApplicationTheme(ApplicationTheme.BuilderImpl applicationTheme) {
            this.applicationTheme = applicationTheme != null ? applicationTheme.build() : null;
        }

        @Override
        public final Builder applicationTheme(ApplicationTheme applicationTheme) {
            this.applicationTheme = applicationTheme;
            return this;
        }

        public final LogoConfiguration.Builder getLogoConfiguration() {
            return this.logoConfiguration != null ? this.logoConfiguration.toBuilder() : null;
        }

        public final void setLogoConfiguration(LogoConfiguration.BuilderImpl logoConfiguration) {
            this.logoConfiguration = logoConfiguration != null ? logoConfiguration.build() : null;
        }

        @Override
        public final Builder logoConfiguration(LogoConfiguration logoConfiguration) {
            this.logoConfiguration = logoConfiguration;
            return this;
        }

        public BrandDefinition build() {
            return new BrandDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrandDefinition> {
        public Builder brandName(String var1);

        public Builder description(String var1);

        public Builder applicationTheme(ApplicationTheme var1);

        default public Builder applicationTheme(Consumer<ApplicationTheme.Builder> applicationTheme) {
            return this.applicationTheme((ApplicationTheme)((ApplicationTheme.Builder)ApplicationTheme.builder().applyMutation(applicationTheme)).build());
        }

        public Builder logoConfiguration(LogoConfiguration var1);

        default public Builder logoConfiguration(Consumer<LogoConfiguration.Builder> logoConfiguration) {
            return this.logoConfiguration((LogoConfiguration)((LogoConfiguration.Builder)LogoConfiguration.builder().applyMutation(logoConfiguration)).build());
        }
    }
}

